/*
 * Decompiled with CFR 0.152.
 */
import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.Date;

public class SensorFrameworkAPIDemo {
    public static void main(String[] args) {
        SensorFrameworkDataset.singleton().addDataSource(new MemoryDAOFactory(-1L));
        IDAOFactory f = SensorFrameworkDataset.singleton().getDataSourceByID(1L);
        Experiment e = f.createExperimentDAO().addExperiment("Test");
        ExperimentRun er = e.addExperimentRun("TestRun " + new Date().toString());
        TimeSpanSensor s = e.addTimeSpanSensor("ATimeSpanSensor");
        State busyState = f.createStateDAO().addState("Busy");
        State idleState = f.createStateDAO().addState("Idle");
        StateSensor stateSen = e.addStateSensor(idleState, "AStateSensor");
        stateSen.addSensorState(busyState);
        stateSen.addSensorState(idleState);
        boolean flag = false;
        double valueSum = 0.0;
        long start = System.nanoTime();
        int i = 0;
        while (i < 200000) {
            if (i % 1000 == 0) {
                System.out.print(".");
            }
            if (i % 100000 == 0) {
                System.out.print("\n");
            }
            double value = Math.random() * 5000.0;
            er.addTimeSpanMeasurement(s, value, value);
            er.addStateMeasurement(stateSen, flag ? busyState : idleState, valueSum);
            flag = !flag;
            valueSum += value;
            ++i;
        }
        System.out.println("\nDone creating measurements: " + (double)(System.nanoTime() - start) / Math.pow(10.0, 9.0) + " s");
        f.finalizeAndClose();
        System.out.println("Done storing: " + (double)(System.nanoTime() - start) / Math.pow(10.0, 9.0) + " s");
        System.out.println(er.getMeasurementsOfSensor(s).getMeasurements().size());
        System.out.println("Done " + (double)(System.nanoTime() - start) / Math.pow(10.0, 9.0) + " s");
    }
}

