/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.dialogs.dataset.DatasourceListLabelProvider;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationImages;
import de.uka.ipd.sdq.sensorframework.visualisation.views.ExperimentAndDAO;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeContainer;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TreeLabelProvider
extends LabelProvider {
    public String getText(Object obj) {
        if (obj instanceof ExperimentAndDAO) {
            return ((ExperimentAndDAO)obj).getExperiment().getExperimentName();
        }
        if (obj instanceof TreeContainer) {
            return ((TreeContainer)obj).getName();
        }
        if (obj instanceof TreeObject) {
            TreeObject object = (TreeObject)obj;
            if (object.getObject() instanceof ExperimentRun) {
                ExperimentRun run = (ExperimentRun)object.getObject();
                return this.runRepresentation(run);
            }
            if (object.getObject() instanceof Sensor) {
                Sensor sensor = (Sensor)object.getObject();
                return this.sensorRepresentation(sensor);
            }
        }
        if (obj instanceof IDAOFactory) {
            IDAOFactory factory = (IDAOFactory)obj;
            return DatasourceListLabelProvider.dataSetRepresentation((IDAOFactory)factory);
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof ExperimentAndDAO) {
            return VisualisationImages.imageRegistry.get("experiment_obj");
        }
        if (obj instanceof TreeContainer) {
            String icon = "";
            TreeContainer container = (TreeContainer)obj;
            switch (container.getType()) {
                case 0: {
                    icon = "run_folder";
                    break;
                }
                case 1: {
                    icon = "sensor_folder";
                }
            }
            return VisualisationImages.imageRegistry.get(icon);
        }
        if (obj instanceof TreeObject) {
            TreeObject object = (TreeObject)obj;
            if (object.getObject() instanceof ExperimentRun) {
                return VisualisationImages.imageRegistry.get("lrun_obj");
            }
            if (object.getObject() instanceof Sensor) {
                return VisualisationImages.imageRegistry.get("sensor_obj");
            }
        }
        if (obj instanceof IDAOFactory) {
            return VisualisationImages.imageRegistry.get("tree_root");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public String sensorRepresentation(Sensor sensor) {
        return String.valueOf(sensor.getSensorName()) + " [ID:" + sensor.getSensorID() + "]";
    }

    public String runRepresentation(ExperimentRun run) {
        return String.valueOf(run.getExperimentDateTime()) + " [ID:" + run.getExperimentRunID() + "]";
    }
}

