/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import de.uka.ipd.sdq.sensorframework.visualisation.views.ExperimentAndDAO;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeContainer;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeContentProvider
implements ITreeContentProvider {
    protected static final int EXPERIMENT_RUNS = 0;
    protected static final int SENSORS = 1;
    private List<IDAOFactory> rootEntry;

    public Object[] getElements(Object parent) {
        this.rootEntry = new ArrayList<IDAOFactory>();
        this.rootEntry.addAll(SensorFrameworkDataset.singleton().getDataSources());
        return this.getChildren(this.rootEntry);
    }

    public Object[] getChildren(Object parent) {
        TreeObject treeObject;
        if (parent instanceof ArrayList) {
            return ((ArrayList)parent).toArray();
        }
        if (parent instanceof IDAOFactory) {
            IExperimentDAO experimentDAO = ((IDAOFactory)parent).createExperimentDAO();
            return this.createExperimentAndDAOList((IDAOFactory)parent, experimentDAO.getExperiments()).toArray();
        }
        if (parent instanceof ExperimentAndDAO) {
            ExperimentAndDAO experiment = (ExperimentAndDAO)parent;
            Object[] objects = new Object[]{new TreeContainer(experiment.getDatasource(), experiment.getExperiment(), 0), new TreeContainer(experiment.getDatasource(), experiment.getExperiment(), 1)};
            return objects;
        }
        if (parent instanceof TreeObject && (treeObject = (TreeObject)parent).getObject() instanceof ExperimentRun) {
            ExperimentRun run = (ExperimentRun)treeObject.getObject();
            Experiment experiment = treeObject.getExperiment();
            Collection sensors = experiment.getSensors();
            Object[] objects = new Object[sensors.size()];
            int i = 0;
            for (Sensor s : sensors) {
                objects[i++] = new TreeObject(s, treeObject.getDatasource(), experiment, run);
            }
            return objects;
        }
        if (parent instanceof TreeContainer) {
            return ((TreeContainer)parent).getElements().toArray();
        }
        return new Object[0];
    }

    private List<ExperimentAndDAO> createExperimentAndDAOList(IDAOFactory dao, Collection<Experiment> experiments) {
        ArrayList<ExperimentAndDAO> result = new ArrayList<ExperimentAndDAO>();
        for (Experiment e : experiments) {
            result.add(new ExperimentAndDAO(dao, e));
        }
        return result;
    }

    public boolean hasChildren(Object parent) {
        TreeObject object;
        if (parent instanceof TreeObject && (object = (TreeObject)parent).getObject() instanceof Sensor) {
            return false;
        }
        if (parent instanceof IDAOFactory) {
            IExperimentDAO experimentDAO = ((IDAOFactory)parent).createExperimentDAO();
            return !experimentDAO.getExperiments().isEmpty();
        }
        return true;
    }

    public void dispose() {
        if (this.rootEntry != null) {
            this.rootEntry.clear();
        }
    }

    public Object getParent(Object child) {
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

