/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.editor;

import de.uka.ipd.sdq.sensorframework.adapter.AdapterRegistry;
import de.uka.ipd.sdq.sensorframework.adapter.IAdapterFactory;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.ActionListSelectionDialog;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.ViewAndAdapterFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.DialogLabelProvider;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SensorValidationToView {
    public static Object[] findViews(SensorAndMeasurements sensorAndMeasurements) {
        IConfigurationElement[] elements;
        ArrayList<ViewAndAdapterFactory> result = new ArrayList<ViewAndAdapterFactory>();
        IConfigurationElement[] iConfigurationElementArray = elements = SensorValidationToView.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String executableObject = element.getAttribute("acceptsData");
            try {
                Class<?> viewerAcceptsClass = Class.forName(executableObject);
                if (AdapterRegistry.singleton().canAdapt(sensorAndMeasurements, viewerAcceptsClass)) {
                    for (IAdapterFactory f : AdapterRegistry.singleton().getAllAvailableFactories(sensorAndMeasurements, viewerAcceptsClass)) {
                        result.add(new ViewAndAdapterFactory(element, f));
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return result.toArray();
    }

    public static boolean canViewSensor(SensorAndMeasurements sensorAndMeasurements) {
        String activeEditorId = VisualisationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite().getId();
        Object[] views = SensorValidationToView.findViews(sensorAndMeasurements);
        int i = 0;
        while (i < views.length) {
            ViewAndAdapterFactory viewer = (ViewAndAdapterFactory)views[i];
            String editorId = viewer.getView().getAttribute("editorID");
            if (activeEditorId.equals(editorId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IConfigurationElement[] getConfigurationElements() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("de.uka.ipd.sdq.sensorframework.visualisation");
        return configurationElements;
    }

    public static void showMessage(Shell shell) {
        String msg = "This View do not support the representation of the selected sensor!";
        String editorName = VisualisationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getTitle();
        MessageDialog.openInformation((Shell)shell, (String)editorName, (String)msg);
    }

    public static ViewAndAdapterFactory getSelectedAction(Shell shell, Object[] elements) {
        ActionListSelectionDialog dialog = new ActionListSelectionDialog(shell, new DialogLabelProvider());
        dialog.setElements(elements);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null) {
            return (ViewAndAdapterFactory)results[0];
        }
        return null;
    }
}

