/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.sensorframework.adapter.IAdapter;
import de.uka.ipd.sdq.sensorframework.adapter.IAdapterFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AdapterRegistry {
    private static AdapterRegistry singletonInstance = new AdapterRegistry();
    private static HashMap<String, IAdapterFactory> factories = new HashMap();

    public static AdapterRegistry singleton() {
        return singletonInstance;
    }

    private AdapterRegistry() {
    }

    public void addAdapterFactory(IAdapterFactory adapterFactory) {
        factories.put(adapterFactory.getAdapterFactoryID(), adapterFactory);
    }

    public boolean canAdapt(Object adaptee, Class<?> targetClass) {
        return this.getAllAvailableFactories(adaptee, targetClass).size() > 0;
    }

    public IAdapter getAdapter(Object objToAdapt, Class<?> class1) {
        return this.getAllAvailableFactories(objToAdapt, class1).get(0).getAdapter(objToAdapt);
    }

    public List<IAdapterFactory> getAllAvailableFactories(Class<?> targetClass) {
        ArrayList<IAdapterFactory> result = new ArrayList<IAdapterFactory>();
        for (IAdapterFactory factory : factories.values()) {
            if (!factory.createsAdaptersFor(targetClass)) continue;
            result.add(factory);
        }
        return result;
    }

    public List<IAdapterFactory> getAllAvailableFactories(Object adaptee, Class<?> targetClass) {
        ArrayList<IAdapterFactory> result = new ArrayList<IAdapterFactory>();
        for (IAdapterFactory factory : factories.values()) {
            if (!factory.canAdapt(adaptee, targetClass)) continue;
            result.add(factory);
        }
        return result;
    }

    public IAdapterFactory getFactoryByID(String factoryID) {
        return factories.get(factoryID);
    }
}

