/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils;

import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.RVisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reports.RReport;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils.RConnection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.rosuda.JRI.REXP;

public class REngineHelper {
    public static final TransferType TRANSFER_TYPE = TransferType.FILE;

    public static String storeMeasurementsInRVector(SensorAndMeasurements measurements, int sensorNumber, RReport.TimeseriesData dataSelection, RConnection rConnection) {
        return REngineHelper.storeMeasurementsInRVector(measurements, sensorNumber, dataSelection, TRANSFER_TYPE, rConnection);
    }

    public static String storeMeasurementsInRVector(SensorAndMeasurements measurements, int sensorNumber, RReport.TimeseriesData dataSelection, TransferType transferType, RConnection rConnection) {
        String sensorName = null;
        if (dataSelection == RReport.TimeseriesData.TIMESPAN) {
            sensorName = "sensor" + sensorNumber;
        } else if (dataSelection == RReport.TimeseriesData.EVENTTIME) {
            sensorName = "sensor" + sensorNumber + "_ET";
        } else {
            throw new RuntimeException("Unknown data element of time series.");
        }
        if (transferType == TransferType.MEMORY) {
            double[] measurementsArray = REngineHelper.prepareExportToRByMemory(measurements, dataSelection);
            rConnection.assign(sensorName, measurementsArray);
        }
        if (transferType == TransferType.FILE) {
            String rCommand = String.valueOf(sensorName) + " <- " + REngineHelper.prepareExportToRByFile(measurements, dataSelection);
            Vector<REXP> result = rConnection.execute(rCommand);
            if (!rConnection.getLastConsoleMessage().equalsIgnoreCase("Read " + measurements.getMeasurements().size() + " items\n")) {
                String rResults = "Executing command: '" + rCommand + "' with ";
                for (REXP currentResult : result) {
                    rResults = String.valueOf(rResults) + "String: " + currentResult.asString() + ", SymbolName: " + currentResult.asSymbolName() + ", Type: " + currentResult.getType() + "\n";
                }
                RVisualisationPlugin.log(1, "Storing Measurements in R via file is most likely wrong. Last message on the console was: " + rConnection.getLastConsoleMessage() + "R returned:\n" + rResults);
            }
        }
        return sensorName;
    }

    private static double[] prepareExportToRByMemory(SensorAndMeasurements measurements, RReport.TimeseriesData dataSelection) {
        double[] measurementsArray = new double[measurements.getMeasurements().size()];
        if (measurements.getMeasurements().size() == Integer.MAX_VALUE) {
            RVisualisationPlugin.log(4, "Too many measurements. Results might be inaccurate.");
        }
        int position = 0;
        for (Measurement time : measurements.getMeasurements()) {
            TimeSpanMeasurement tsm = (TimeSpanMeasurement)time;
            double d = measurementsArray[position++] = dataSelection == RReport.TimeseriesData.EVENTTIME ? tsm.getEventTime() : tsm.getTimeSpan();
        }
        return measurementsArray;
    }

    private static String prepareExportToRByFile(SensorAndMeasurements measurements, RReport.TimeseriesData dataSelection) {
        try {
            File temporaryFile = File.createTempFile("data", dataSelection == RReport.TimeseriesData.EVENTTIME ? "_et.txt" : "_ts.txt");
            temporaryFile.deleteOnExit();
            FileWriter temporaryFileWriter = new FileWriter(temporaryFile);
            StringBuffer result = new StringBuffer();
            for (Measurement time : measurements.getMeasurements()) {
                TimeSpanMeasurement tsm = (TimeSpanMeasurement)time;
                result.append(dataSelection == RReport.TimeseriesData.EVENTTIME ? tsm.getEventTime() : tsm.getTimeSpan());
                result.append(" ");
            }
            temporaryFileWriter.write(result.toString());
            temporaryFileWriter.close();
            return "scan(file=\"" + temporaryFile.getAbsolutePath().replace(File.separator, "\\\\") + "\")";
        }
        catch (IOException e) {
            RVisualisationPlugin.log(4, "Error accessing temporary file to transfer sensordata to R. \n\n Details: " + e.getMessage());
            return "";
        }
    }

    public static enum TransferType {
        FILE,
        MEMORY;

    }
}

