/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils;

import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.RVisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils.RTextConsole;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;

public class RConnection {
    private static Logger logger = Logger.getLogger((String)RConnection.class.getName());
    private static RTextConsole rConsole = new RTextConsole();
    private static Rengine rengine = null;
    private static RConnection rConnection = null;

    static {
        rConnection = new RConnection();
    }

    public RConnection() {
        this.initalizeConnection();
    }

    protected void initalizeConnection() {
        if (rConnection != null) {
            return;
        }
        this.checkPathValidity();
        try {
            System.loadLibrary("jri");
        }
        catch (UnsatisfiedLinkError ule) {
            RVisualisationPlugin.log(4, "Could not load the dynamic link libaries that are necessary to connect the sensorframework  to R 2.6. The JRI provided with this package is designed for R 2.6.1, check the detailed error message if a version conflict may have occured.Ensure jri.dll is within the java.library.path variable and R's bin directory is on the system path. Details: java.library.path=" + System.getProperty("java.library.path") + ";errorMessage=" + ule.getMessage());
            new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error loading R", null, "Could not load R 2.6. You need to install the correct Version of R on your machine. Put R's binary folder into your system path, so the dynamic link libraries can be found. Check the error log for a detailed message.", 1, new String[]{"OK"}, 0).open();
            return;
        }
        if (!Rengine.versionCheck()) {
            RVisualisationPlugin.log(4, "Creating R engine ** Version mismatch - Java files don't match library version.");
            new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error loading R", null, "Could not load R. The version of the java files and the library versions dont match.", 1, new String[]{"OK"}, 0).open();
            return;
        }
        rengine = new Rengine(new String[0], false, (RMainLoopCallbacks)rConsole);
        if (!rengine.waitForR()) {
            RVisualisationPlugin.log(4, "Creating R engine ** Waiting for the R engine to come up failed.");
            new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error loading R", null, "Could not load R. The R engine didn't come up in time.", 1, new String[]{"OK"}, 0).open();
            rengine = null;
            return;
        }
        RVisualisationPlugin.log(1, "Connection to R established successfully.");
        this.prepareEnvironment();
        this.checkPackageAvailability();
    }

    private void checkPackageAvailability(String packageName) {
        String previousMessage = this.getLastConsoleMessage();
        rengine.eval("library(" + packageName + ")");
        String result = this.getLastConsoleMessage();
        if (!previousMessage.equals(result)) {
            RVisualisationPlugin.log(4, "Library \"" + packageName + "\" is not available. Please " + "install the \"" + packageName + "\" package in your R " + "installation.\n Error details: " + result + "\n" + "Possible Solution: \n" + "If you are using Windows Vista check if the package is " + "in the installation path of R and not in the user path." + "This can be achieved by executing the R command " + "\"library\".");
            IWorkbenchWindow wbw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (wbw != null) {
                new MessageDialog(wbw.getShell(), "Library \"" + packageName + "\" is not available in R", null, "The library \"" + packageName + "\" is not available. " + "Please install the \"" + packageName + "\" package in " + "your R installation or" + " the R reports will not work properly. Check the PDE " + "error log for more information.", 1, new String[]{"OK"}, 0).open();
            }
        }
    }

    private void checkPackageAvailability() {
        this.checkPackageAvailability("plotrix");
    }

    private void checkPathValidity() {
        String libraryPath = System.getProperty("java.library.path");
        String[] libraryPaths = libraryPath.split(";");
        Vector<String> conflictingPaths = new Vector<String>();
        String[] stringArray = libraryPaths;
        int n = libraryPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.contains(" ") && !path.startsWith("\"") && !path.endsWith("\"")) {
                conflictingPaths.add(path);
            }
            ++n2;
        }
        if (!conflictingPaths.isEmpty()) {
            String formattedPath = "";
            for (String conflictPath : conflictingPaths) {
                formattedPath = String.valueOf(formattedPath) + "'" + conflictPath + "', ";
            }
            formattedPath = formattedPath.substring(0, formattedPath.length() - 2);
            RVisualisationPlugin.log(2, "The environment variable java.library.path contains  unescaped spaces. This may lead to errors loading the necessary dynamic link libraries of R.\n\nConflicting parts of the java.library.path are: " + formattedPath + "\n\n" + "A possible solution is to set the library path to" + " point to the path containing jri.dll via the -D" + " command line switch of the java VM of by setting" + " it via the eclipse.ini file. However, this does" + " not work in all cases.");
        }
    }

    private void prepareEnvironment() {
        rengine.eval("Sys.setlocale(\"LC_ALL\", \"German_Germany.1252\")");
        rengine.eval("Sys.setlocale(\"LC_NUMERIC\", \"C\")");
        rengine.eval("rUser <- chartr(\"\\\\\", \"/\", Sys.getenv(\"R_USER\"))");
        rengine.eval("rLibs <- chartr(\"\\\\\", \"/\", Sys.getenv(\"R_LIBS_USER\"))");
        rengine.eval("homedrive <- chartr(\"\\\\\", \"/\", Sys.getenv(\"HOMEDRIVE\"))");
        rengine.eval("homepath <- chartr(\"\\\\\", \"/\", Sys.getenv(\"HOMEPATH\"))");
        rengine.eval("usrLibPath <- substring(strsplit(rLibs, rUser)[[1]][2],2)");
        rengine.eval("Sys.setenv(\"R_USER\"=paste(homedrive, homepath, sep=\"\"))");
        rengine.eval("Sys.setenv(\"R_LIBS_USER\"=paste(Sys.getenv(\"R_USER\"), usrLibPath, sep=\"\")[[1]])");
        REXP envContent = rengine.eval("Sys.getenv()");
        REXP envNames = rengine.eval("names(s <- Sys.getenv())");
        String[] sEnvContent = envContent.asStringArray();
        String[] sEnvNames = envNames.asStringArray();
        String locale = "";
        int number = 0;
        while (number < sEnvContent.length) {
            locale = String.valueOf(locale) + sEnvNames[number] + " = " + sEnvContent[number] + "\n";
            ++number;
        }
        REXP locales = rengine.eval("Sys.getlocale()");
        String[] sLocales = locales.asStringArray();
        locale = String.valueOf(locale) + "\nLocalization information:\n";
        int number2 = 0;
        while (number2 < sLocales.length) {
            locale = String.valueOf(locale) + sLocales[number2] + "\n";
            ++number2;
        }
        logger.debug((Object)("Environmental Information:\n" + locale));
    }

    public Vector<REXP> execute(String rCommands) {
        if (!RConnection.isEngineAvailable()) {
            throw new UnsupportedOperationException("Tried to execute command in R without having a R engine available.");
        }
        String[] commands = rCommands.split("\n");
        String result = "";
        Vector<REXP> resultExpArray = new Vector<REXP>();
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            REXP resultExp = rengine.eval(command);
            if (resultExp != null) {
                result = String.valueOf(result) + resultExp.toString() + "\n";
                resultExpArray.add(resultExp);
            }
            ++n2;
        }
        return resultExpArray;
    }

    public void assign(String name, double[] array) {
        rengine.assign(name, array);
    }

    public static boolean isEngineAvailable() {
        return rengine != null;
    }

    public static RConnection getRConnection() {
        return rConnection;
    }

    public String getLastConsoleMessage() {
        return rConsole.getLastMessage();
    }
}

