/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartChart;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.Document;

class SaveSVGAsAction
extends Action {
    private AbstractJFreeChartChart<?> chartViewer;

    public SaveSVGAsAction(AbstractJFreeChartChart<?> abstractJFreeChartChart) {
        this.setText("Save Chart as SVG...");
        this.chartViewer = abstractJFreeChartChart;
    }

    public void run() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setFilterExtensions(new String[]{"*.svg"});
        dialog.setText("Enter the image file name");
        dialog.open();
        if (dialog.getFileName() != null) {
            String filename = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName();
            File f = new File(filename);
            JFreeChart chart = this.chartViewer.getChart();
            try {
                GenericDOMImplementation domI = new GenericDOMImplementation();
                Document doc = domI.createDocument(null, "svg", null);
                SVGGraphics2D svgRenderer = new SVGGraphics2D(doc);
                Paint p = chart.getBackgroundPaint();
                chart.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
                chart.draw((Graphics2D)svgRenderer, (Rectangle2D)new Rectangle(0, 0, 640, 480));
                chart.setBackgroundPaint(p);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
                svgRenderer.stream((Writer)out, true);
                ((Writer)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

