/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartWidthViewer;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ExportCSV;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ExportDoublePDF;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IHistSeriesExporter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IHistogramAccepter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.LoadCSVHistogram;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;

public class JFreeChartHistogramViewer
extends AbstractJFreeChartWidthViewer
implements IHistogramAccepter,
IHistSeriesExporter {
    private Logger logger;

    public JFreeChartHistogramViewer(Composite parent, int style) {
        this(parent, style, null);
    }

    public JFreeChartHistogramViewer(Composite parent, int style, String xAxisLabel) {
        super(parent, style);
        this.DEFAULT_X_AXIS_LABEL = "Values";
        this.logger = Logger.getLogger((String)this.getClass().getName());
        if (xAxisLabel != null && xAxisLabel.length() > 0) {
            this.xAxisLabel = xAxisLabel;
            this.xAxisCustomSet = true;
        } else {
            this.xAxisLabel = this.DEFAULT_X_AXIS_LABEL;
            this.xAxisCustomSet = false;
            this.logger.error((Object)("Passed xAxisLabel was null or empty, using the default one: " + this.DEFAULT_X_AXIS_LABEL));
        }
    }

    @Override
    public void addHistogram(Histogram histogram) {
        this.setCustomXAxisLabel(histogram);
        this.densityDataset.addSeries(this.computeDensities(histogram));
        this.densityDataset.setAutoWidth(true);
        this.initChart();
        this.redraw();
    }

    @Override
    protected XYSeries computeDensities(Histogram hist) {
        XYSeries density = new XYSeries((Comparable)((Object)hist.getTitle()), true, false);
        for (HistogramBucketInformation bucketInformation : hist.getBucketInformation()) {
            double xValue = bucketInformation.getValue() + hist.getBucketWidth() / 2.0;
            density.add(xValue, bucketInformation.getProbability());
        }
        return density;
    }

    @Override
    public double getHistogramWidth() {
        return this.densityDataset.getIntervalWidth();
    }

    @Override
    public XYSeries getSeries() {
        this.logger.info((Object)"Only the first series of densityDataset is returned");
        return this.densityDataset.getSeries(0);
    }

    @Override
    protected void initChart() {
        this.chart = ChartFactory.createHistogram((String)"Histogram", (String)this.xAxisLabel, (String)"Probability", (IntervalXYDataset)this.densityDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.getRangeAxis().setAutoRange(true);
        plot.setForegroundAlpha(0.8f);
        if (this.densityDataset != null) {
            this.densityDataset.setAutoWidth(true);
        }
    }

    @Override
    protected void initializeContextMenu(MenuManager menu_manager) {
        super.initializeContextMenu(menu_manager);
        menu_manager.add((IAction)new LoadCSVHistogram(this));
        menu_manager.add((IAction)new ExportCSV(this));
        menu_manager.add((IAction)new ExportDoublePDF(this));
    }
}

