/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.tests.util;

import de.uka.ipd.sdq.sensorframework.tests.util.DirDeleter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class TempDir {
    private static DirDeleter deleterThread = new DirDeleter();

    static {
        Runtime.getRuntime().addShutdownHook(deleterThread);
    }

    public static File createGeneratedName(String prefix) throws IOException {
        return TempDir.createGeneratedName(prefix, null);
    }

    public static File createGeneratedName(String prefix, File directory) throws IOException {
        File tempFile = File.createTempFile(prefix, "", directory);
        if (!tempFile.delete()) {
            throw new IOException();
        }
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        deleterThread.add(tempFile);
        return tempFile;
    }

    public static File createNamed(String name, File directory) throws IOException {
        File tempFile = new File(directory, name);
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        deleterThread.add(tempFile);
        return tempFile;
    }

    public static void main(String[] args) {
        try {
            int serial = 123;
            File tempDir = TempDir.createNamed("" + serial, new File("c:\\project"));
            File f = new File(tempDir, "hello.txt");
            FileWriter fw = new FileWriter(f);
            fw.write("hello");
            fw.close();
            System.out.println("Temp dir created is " + tempDir.getPath());
            System.out.println("Temp dir (and all its content) will be deleted on exit");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

