/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.tests;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class AbstractSerialiserTests
extends TestCase {
    private static final int CREATE_COUNT = 10;

    public void testExperimentStore() throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        int i = 0;
        while (i < 10) {
            experimentDAO.addExperiment("Test" + i);
            ++i;
        }
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        experimentDAO = factory.createExperimentDAO();
        int count = 0;
        for (Experiment e : experimentDAO.getExperiments()) {
            ++count;
            Assert.assertEquals((int)0, (int)e.getSensors().size());
            Assert.assertEquals((int)0, (int)e.getExperimentRuns().size());
        }
        Assert.assertEquals((int)10, (int)experimentDAO.getExperiments().size());
        Assert.assertEquals((int)10, (int)count);
        factory.finalizeAndClose();
    }

    public void testExperimentStoreAfterReload() throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        factory.finalizeAndClose();
        int i = 0;
        while (i < 10) {
            factory = this.createDAOFactory();
            IExperimentDAO experimentDAO = factory.createExperimentDAO();
            experimentDAO.addExperiment("Test" + i);
            factory.finalizeAndClose();
            ++i;
        }
        factory = this.createDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        int count = 0;
        for (Experiment e : experimentDAO.getExperiments()) {
            ++count;
            Assert.assertEquals((int)0, (int)e.getSensors().size());
            Assert.assertEquals((int)0, (int)e.getExperimentRuns().size());
        }
        factory.finalizeAndClose();
        Assert.assertEquals((int)10, (int)count);
    }

    public void testSensorStore() throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment e = experimentDAO.addExperiment("Test");
        this.addTimeSpanSensors(factory, e);
        this.addStateSensors(factory, e);
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        experimentDAO = factory.createExperimentDAO();
        for (Experiment ex : experimentDAO.getExperiments()) {
            int count = 0;
            int tssCount = 0;
            int stateCount = 0;
            for (Sensor s : ex.getSensors()) {
                ++count;
                if (s instanceof TimeSpanSensor) {
                    ++tssCount;
                } else {
                    ++stateCount;
                    Assert.assertEquals((int)1, (int)((StateSensor)s).getSensorStates().size());
                }
                Assert.assertTrue((boolean)(s instanceof TimeSpanSensor ? s.getSensorName().startsWith("TSS") : s.getSensorName().startsWith("StateSensor")));
            }
            Assert.assertEquals((int)20, (int)count);
            Assert.assertEquals((int)10, (int)tssCount);
            Assert.assertEquals((int)10, (int)stateCount);
        }
        factory.finalizeAndClose();
    }

    public void testSensorStore2() throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment e = experimentDAO.addExperiment("Test");
        this.addStateSensors(factory, e);
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        int statesCount = factory.createStateDAO().getStates().size();
        factory.finalizeAndClose();
        Assert.assertEquals((int)1, (int)statesCount);
    }

    public void testExperimentRunStore() throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment e = experimentDAO.addExperiment("Test");
        this.addTimeSpanSensors(factory, e);
        this.addStateSensors(factory, e);
        this.addExperimentRuns(factory, e);
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        experimentDAO = factory.createExperimentDAO();
        for (Experiment ex : experimentDAO.getExperiments()) {
            int count = 0;
            for (ExperimentRun er : ex.getExperimentRuns()) {
                ++count;
                Assert.assertTrue((boolean)er.getExperimentDateTime().startsWith("Date"));
            }
            Assert.assertEquals((int)10, (int)count);
        }
        factory.finalizeAndClose();
    }

    public void testExperimentRunStore2() throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment e = experimentDAO.addExperiment("Test");
        this.addExperimentRuns(factory, e);
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        int count = factory.createExperimentRunDAO().getExperimentRuns().size();
        Assert.assertEquals((int)10, (int)count);
        factory.finalizeAndClose();
    }

    public void testExperimentRunStoreAfterReload() throws IOException {
        this.testExperimentRunStore();
        IDAOFactory factory = this.createDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment e = experimentDAO.addExperiment("Test2");
        this.addTimeSpanSensors(factory, e);
        this.addStateSensors(factory, e);
        this.addExperimentRuns(factory, e);
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        experimentDAO = factory.createExperimentDAO();
        int count = 0;
        Iterator iterator = experimentDAO.getExperiments().iterator();
        while (iterator.hasNext()) {
            Experiment cfr_ignored_0 = (Experiment)iterator.next();
            ++count;
        }
        Assert.assertEquals((int)2, (int)count);
        factory.finalizeAndClose();
    }

    public void testTimeSpanMeasurements() throws IOException {
        this.testTimeSpanMeasurementsInternal(10);
    }

    public void testTimeSpanMeasurementsLarge() throws IOException {
        this.testTimeSpanMeasurementsInternal(123573);
    }

    private void testTimeSpanMeasurementsInternal(int createCount) throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment e = experimentDAO.addExperiment("Test2");
        this.addTimeSpanSensors(factory, e);
        this.addExperimentRuns(factory, e);
        this.addTimeSpanMeasurements(factory, e, createCount);
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        experimentDAO = factory.createExperimentDAO();
        e = (Experiment)experimentDAO.getExperiments().iterator().next();
        TimeSpanSensor tss = (TimeSpanSensor)e.getSensors().iterator().next();
        ExperimentRun er = (ExperimentRun)e.getExperimentRuns().iterator().next();
        SensorAndMeasurements sam = er.getMeasurementsOfSensor((Sensor)tss);
        Assert.assertEquals((Object)tss, (Object)sam.getSensor());
        int count = 0;
        for (Measurement m : sam.getMeasurements()) {
            Assert.assertTrue((boolean)(m instanceof TimeSpanMeasurement));
            TimeSpanMeasurement tsm = (TimeSpanMeasurement)m;
            Assert.assertTrue((tsm.getTimeSpan() > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((tsm.getEventTime() > 0.0 ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((int)createCount, (int)count);
        Assert.assertEquals((int)createCount, (int)sam.getMeasurements().size());
        factory.finalizeAndClose();
    }

    public void testStateMeasurements() throws IOException {
        this.testStateMeasurementsInternal(10);
    }

    public void testStateMeasurementsLarge() throws IOException {
        this.testStateMeasurementsInternal(123573);
    }

    private void testStateMeasurementsInternal(int createCount) throws IOException {
        IDAOFactory factory = this.createCleanDAOFactory();
        IExperimentDAO experimentDAO = factory.createExperimentDAO();
        Experiment e = experimentDAO.addExperiment("Test2");
        this.addStateSensors(factory, e);
        this.addExperimentRuns(factory, e);
        this.addStateMeasurements(factory, e, createCount);
        factory.finalizeAndClose();
        factory = this.createDAOFactory();
        experimentDAO = factory.createExperimentDAO();
        e = (Experiment)experimentDAO.getExperiments().iterator().next();
        StateSensor ssensor = (StateSensor)e.getSensors().iterator().next();
        ExperimentRun er = (ExperimentRun)e.getExperimentRuns().iterator().next();
        SensorAndMeasurements sam = er.getMeasurementsOfSensor((Sensor)ssensor);
        Assert.assertEquals((Object)ssensor, (Object)sam.getSensor());
        int count = 0;
        for (Measurement m : sam.getMeasurements()) {
            Assert.assertTrue((boolean)(m instanceof StateMeasurement));
            StateMeasurement sm = (StateMeasurement)m;
            Assert.assertNotNull((Object)sm.getSensorState());
            Assert.assertEquals((Object)sm.getSensorState(), (Object)ssensor.getInitialState());
            Assert.assertTrue((sm.getEventTime() > 0.0 ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((int)createCount, (int)count);
        Assert.assertEquals((int)createCount, (int)sam.getMeasurements().size());
        factory.finalizeAndClose();
    }

    private void addTimeSpanMeasurements(IDAOFactory factory, Experiment e, int create_count) {
        TimeSpanSensor tss = (TimeSpanSensor)e.getSensors().iterator().next();
        ExperimentRun er = (ExperimentRun)e.getExperimentRuns().iterator().next();
        int i = 0;
        while (i < create_count) {
            er.addTimeSpanMeasurement(tss, (double)(i + 1), (double)(i + 1));
            ++i;
        }
    }

    private void addStateMeasurements(IDAOFactory factory, Experiment e, int createCount) {
        StateSensor ssensor = (StateSensor)e.getSensors().iterator().next();
        ExperimentRun er = (ExperimentRun)e.getExperimentRuns().iterator().next();
        int i = 0;
        while (i < createCount) {
            er.addStateMeasurement(ssensor, ssensor.getInitialState(), (double)(i + 1));
            ++i;
        }
    }

    private void addExperimentRuns(IDAOFactory factory, Experiment e) {
        int i = 0;
        while (i < 10) {
            ExperimentRun run = factory.createExperimentRunDAO().addExperimentRun("Date" + i);
            e.addExperimentRun(run);
            ++i;
        }
    }

    private void addTimeSpanSensors(IDAOFactory factory, Experiment e) {
        int i = 0;
        while (i < 10) {
            TimeSpanSensor s = factory.createSensorDAO().addTimeSpanSensor("TSS" + i);
            e.addSensor((Sensor)s);
            ++i;
        }
    }

    private void addStateSensors(IDAOFactory factory, Experiment e) {
        State state = factory.createStateDAO().addState("AState");
        int i = 0;
        while (i < 10) {
            StateSensor s = factory.createSensorDAO().addStateSensor(state, "StateSensor" + i);
            s.addSensorState(state);
            e.addSensor((Sensor)s);
            ++i;
        }
    }

    protected abstract IDAOFactory createDAOFactory();

    protected abstract IDAOFactory createCleanDAOFactory() throws IOException;
}

