/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.storage.tests;

import de.uka.ipd.sdq.sensorframework.storage.lists.DoubleSerialiser;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DoubleSerialiserTest
extends TestCase {
    public void testDoubleSerialiser() throws IOException {
        File tempFile = File.createTempFile("TestDB", "lst");
        RandomAccessFile raf = new RandomAccessFile(tempFile.getAbsolutePath(), "rw");
        int count = 1000000;
        double[] d = new double[count];
        int i = 0;
        while (i < count) {
            d[i] = Math.random() * 1000.0 - 500.0;
            ++i;
        }
        DoubleSerialiser ds = new DoubleSerialiser();
        byte[] bytes = ds.serialise((Object[])this.toDoubleArray(d), d.length);
        raf.write(bytes);
        raf.seek(0L);
        raf.read(bytes);
        raf.close();
        Assert.assertTrue(((long)bytes.length == ds.getElementLength() * (long)count ? 1 : 0) != 0);
        Double[] doubles = ds.deserialise(bytes);
        int i2 = 0;
        while (i2 < count) {
            Assert.assertEquals((Object)d[i2], (Object)doubles[i2]);
            ++i2;
        }
    }

    private Double[] toDoubleArray(double[] d) {
        Double[] result = new Double[d.length];
        int i = 0;
        while (i < d.length) {
            result[i] = d[i];
            ++i;
        }
        return result;
    }
}

