/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.storage.tests;

import de.uka.ipd.sdq.sensorframework.storage.lists.BackgroundMemoryList;
import de.uka.ipd.sdq.sensorframework.storage.lists.DoubleSerialiser;
import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DoubleListTest
extends TestCase {
    private static final int LARGE_LIST_TEST_COUNT = 1000000;

    public void testList() {
        try {
            File tempFile = File.createTempFile("TempDB", "lst");
            BackgroundMemoryList list = new BackgroundMemoryList(tempFile.getAbsolutePath(), (ISerialiser)new DoubleSerialiser());
            list.add((Object)1.0);
            list.close();
            Assert.assertEquals((long)8L, (long)tempFile.length());
            list = new BackgroundMemoryList(tempFile.getAbsolutePath(), (ISerialiser)new DoubleSerialiser());
            Assert.assertEquals((int)1, (int)list.size());
            Assert.assertEquals((Object)1.0, (Object)list.get(0));
            list.add((Object)2.0);
            Assert.assertEquals((int)2, (int)list.size());
            Assert.assertEquals((Object)2.0, (Object)list.get(1));
            list.close();
            Assert.assertEquals((long)16L, (long)tempFile.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    public void testList2() {
        try {
            File tempFile = File.createTempFile("TempDB", "lst");
            BackgroundMemoryList list = new BackgroundMemoryList(tempFile.getAbsolutePath(), (ISerialiser)new DoubleSerialiser());
            double i = 0.0;
            while (i < 1000000.0) {
                list.add((Object)i);
                i += 1.0;
            }
            list.close();
            Assert.assertEquals((long)8000000L, (long)tempFile.length());
            list = new BackgroundMemoryList(tempFile.getAbsolutePath(), (ISerialiser)new DoubleSerialiser());
            i = 0.0;
            while (i < 1000000.0) {
                Assert.assertEquals((Object)i, (Object)list.get((int)i));
                i += 1.0;
            }
            list.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }
}

