/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dialogs.dataset;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class WizardDatasourceLoadPage
extends WizardPage
implements Listener {
    private static final String WIZARD_TITEL_FOLDER = "Choose the data directory";
    private static final String WIZARD_MSG_FOLDER = "Choose the folder resource.";
    private static final String WIZARD_TITEL_FILE = "Choose the data file";
    private static final String WIZARD_MSG_FILE = "Choose the file resource.";
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 300;
    private static final int SIZING_CONTAINER_GROUP_WIDTH = 250;
    private int type;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private int linkedResourceGroupHeight = -1;
    private Text containerNameField;
    private IResource selectedResource;
    private IFileStore fileStore = null;
    private TreeViewer treeViewer;

    protected WizardDatasourceLoadPage(String pageName, int type) {
        super(pageName);
        this.type = type;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        Label label = new Label(composite, 64);
        label.setText("Enter or select the " + this.getResourceType() + ":");
        label.setFont(this.getFont());
        this.containerNameField = new Text(composite, 2052);
        this.containerNameField.setLayoutData((Object)new GridData(768));
        this.containerNameField.setFont(this.getFont());
        this.createTreeViewer(composite);
        this.createAdvancedControls(composite);
        this.setErrorMessage(null);
        this.setDialogStrings();
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private void setDialogStrings() {
        this.setMessage(null);
        if (this.type == 1) {
            this.setMessage(WIZARD_MSG_FILE);
            this.setTitle(WIZARD_TITEL_FILE);
        }
        if (this.type == 2) {
            this.setMessage(WIZARD_MSG_FOLDER);
            this.setTitle(WIZARD_TITEL_FOLDER);
        }
    }

    protected void createAdvancedControls(Composite parent) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this.linkedResourceParent = new Composite(parent, 0);
            this.linkedResourceParent.setFont(parent.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)layout);
            this.advancedButton = new Button(this.linkedResourceParent, 8);
            this.advancedButton.setFont(this.linkedResourceParent.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData data = this.setButtonLayoutData(this.advancedButton);
            data.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)data);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardDatasourceLoadPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(this.type, (Listener)this, new CreateLinkedResourceGroup.IStringValue(){

            public String getValue() {
                return WizardDatasourceLoadPage.this.containerNameField.getText();
            }

            public void setValue(String string) {
                WizardDatasourceLoadPage.this.containerNameField.setText(string);
            }
        });
    }

    protected void createTreeViewer(Composite parent) {
        DrillDownComposite drillDown = new DrillDownComposite(parent, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.heightHint = 300;
        spec.widthHint = 250;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object object = selection.getFirstElement();
                if (object instanceof IResource) {
                    WizardDatasourceLoadPage.this.selectedResource = (IResource)object;
                    WizardDatasourceLoadPage.this.setPageComplete(WizardDatasourceLoadPage.this.validitaResource(WizardDatasourceLoadPage.this.selectedResource));
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (WizardDatasourceLoadPage.this.treeViewer.getExpandedState(item)) {
                        WizardDatasourceLoadPage.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        WizardDatasourceLoadPage.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public void containerSelectionChanged(String text) {
        if (text.startsWith("/")) {
            text = text.replaceFirst("/", "");
        }
        this.containerNameField.setText(text);
        this.containerNameField.setToolTipText(text);
    }

    private boolean validitaLinkedResource() {
        if (this.linkedResourceGroup != null && this.linkedResourceGroup.getLinkTargetURI() != null) {
            URI uri = this.linkedResourceGroup.getLinkTargetURI();
            URI defaultURI = URIUtil.toURI((String)"");
            if (!uri.toString().equals(defaultURI.toString())) {
                try {
                    this.fileStore = EFS.getStore((URI)uri);
                }
                catch (CoreException coreException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean validitaResource(IResource resource) {
        if (resource == null) {
            return false;
        }
        IFileInfo fileInfo = null;
        try {
            this.fileStore = EFS.getStore((URI)resource.getLocationURI());
        }
        catch (CoreException coreException) {
            return false;
        }
        fileInfo = this.fileStore.fetchInfo();
        if (this.type == 1) {
            return !fileInfo.isDirectory();
        }
        if (this.type == 2) {
            return fileInfo.isDirectory();
        }
        return false;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.linkedResourceGroupHeight);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    public IPath getFileFullPath() {
        if (this.fileStore == null) {
            return null;
        }
        Path path = new Path(this.fileStore.toString());
        path.makeAbsolute();
        return path;
    }

    public void handleEvent(Event event) {
        if (this.linkedResourceComposite != null && !this.linkedResourceComposite.isDisposed()) {
            this.setPageComplete(this.validitaLinkedResource());
        } else {
            this.setPageComplete(this.validitaResource(this.selectedResource));
        }
    }

    private String getResourceType() {
        if (this.type == 1) {
            return "file";
        }
        if (this.type == 2) {
            return "folder";
        }
        return "<undefined>";
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        this.setErrorMessage("No resource selected!");
        if (complete) {
            this.setErrorMessage(null);
            this.containerSelectionChanged(this.fileStore.toString());
        }
    }
}

