/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dialogs.dataset;

import de.uka.ipd.sdq.dialogs.error.ErrorDisplayDialog;
import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryDAOFactory;
import de.uka.ipd.sdq.sensorframework.dialogs.SensorFrameworkDialogPlugin;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.WizardSelectDatasourcePage;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.dialogs.WizardNewFolderMainPage;

public class AddNewDatasourceWizard
extends Wizard {
    private WizardNewFolderMainPage newFolderPage;
    private WizardNewFileCreationPage newDBpage;
    private String result;
    private WizardSelectDatasourcePage selectTypePage;

    public AddNewDatasourceWizard() {
        this.setWindowTitle("Select/create datastore...");
    }

    public void addPages() {
        super.addPages();
        this.selectTypePage = new WizardSelectDatasourcePage("Select Type of Datasource to create", true, true, true);
        this.addPage((IWizardPage)this.selectTypePage);
        this.newDBpage = new WizardNewFileCreationPage("Create new database", (IStructuredSelection)new TreeSelection());
        this.addPage((IWizardPage)this.newDBpage);
        this.newFolderPage = new WizardNewFolderMainPage("Create new data directory", (IStructuredSelection)new TreeSelection());
        this.addPage((IWizardPage)this.newFolderPage);
    }

    public boolean performFinish() {
        if (this.selectTypePage.getResult().equals("Memory Datasource")) {
            SensorFrameworkDataset.singleton().addDataSource((IDAOFactory)new MemoryDAOFactory(""));
        } else if (this.selectTypePage.getResult().equals("File Datasource")) {
            IPath selectedWorkspacePath = this.newFolderPage.createNewFolder().getFullPath();
            IPath targetDirectory = ResourcesPlugin.getWorkspace().getRoot().getFile(selectedWorkspacePath).getLocation();
            try {
                FileDAOFactory fileFactory = new FileDAOFactory(targetDirectory.toOSString());
                SensorFrameworkDataset.singleton().addDataSource((IDAOFactory)fileFactory);
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"File DAO factory error.", (String)ex.getMessage());
                SensorFrameworkDialogPlugin.log(4, ex.getMessage() == null ? "" : ex.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean canFinish() {
        if (this.selectTypePage.getResult().equals("Memory Datasource")) {
            return true;
        }
        if (this.selectTypePage.getResult().equals("DB4O Datasource")) {
            return this.newDBpage.isPageComplete();
        }
        if (this.selectTypePage.getResult().equals("File Datasource")) {
            return this.newFolderPage.isPageComplete();
        }
        return false;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardSelectDatasourcePage) {
            WizardSelectDatasourcePage data_type_page = (WizardSelectDatasourcePage)page;
            if (data_type_page.getResult().equals("DB4O Datasource")) {
                return this.newDBpage;
            }
            if (data_type_page.getResult().equals("File Datasource")) {
                return this.newFolderPage;
            }
        }
        return null;
    }

    public String getResult() {
        return this.result;
    }

    private class ErrorDisplayRunner
    implements Runnable {
        private Throwable e;

        public ErrorDisplayRunner(Throwable e) {
            this.e = e;
        }

        @Override
        public void run() {
            new ErrorDisplayDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.e).open();
        }
    }
}

