/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Pie;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.PieEntity;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class StateSensorToPieAdapter
extends DataAdapter {
    private static final int FACTOR_PERCENT = 100;
    private SensorAndMeasurements samInformation;

    public StateSensorToPieAdapter(SensorAndMeasurements samInformation) {
        this.samInformation = samInformation;
    }

    private double calculateTimeSums(HashMap<String, Double> timeSums) {
        for (State state : ((StateSensor)this.samInformation.getSensor()).getSensorStates()) {
            timeSums.put(state.getStateLiteral(), 0.0);
        }
        double lastChangeTime = 0.0;
        State lastState = ((StateSensor)this.samInformation.getSensor()).getInitialState();
        double sum = 0.0;
        for (Measurement m : this.samInformation.getMeasurements()) {
            StateMeasurement sm = (StateMeasurement)m;
            Double oldValue = timeSums.get(lastState.getStateLiteral());
            double diff = sm.getEventTime() - lastChangeTime;
            double newValue = oldValue + diff;
            sum += diff;
            timeSums.put(lastState.getStateLiteral(), newValue);
            lastChangeTime = sm.getEventTime();
            lastState = sm.getSensorState();
        }
        return sum;
    }

    private Pie createPie(HashMap<String, Double> timeSums, double sum) {
        Pie p = new Pie(((StateSensor)this.samInformation.getSensor()).getSensorName());
        DecimalFormat df = new DecimalFormat("#0.0", new DecimalFormatSymbols(Locale.US));
        for (Map.Entry<String, Double> e : timeSums.entrySet()) {
            if (!(e.getValue() > 0.0)) continue;
            p.addEntity(new PieEntity(e.getValue().doubleValue(), String.valueOf(e.getKey()) + " (" + df.format(e.getValue() * 100.0 / sum) + "%)"));
        }
        return p;
    }

    @Override
    public Object getAdaptedObject() {
        HashMap<String, Double> newPie = new HashMap<String, Double>();
        double sum = this.calculateTimeSums(newPie);
        return this.createPie(newPie, sum);
    }
}

