package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;

/**
 * Adapts SensorAndMeasurements that build on a TimeSpanSensor 
 * into an instance of a Histogram, which describes the throughput
 * @author Henning Groenda, Michael Kuperberg
 *
 */
public class TimeSpanSensorToThroughputHistogramFactory implements IAdapterFactory {

	public boolean canAdapt(Object adaptee, Class<?> targetClass) {
		if (adaptee instanceof SensorAndMeasurements){
			SensorAndMeasurements sam = (SensorAndMeasurements) adaptee;
			if (sam.getSensor() instanceof TimeSpanSensor && targetClass == Histogram.class)
				return true;
		}
		return false;
	}
	
	public boolean createsAdaptersFor(Class<?> targetClass) {
		return targetClass.isAssignableFrom(Histogram.class);
	}

	public DataAdapter getAdapter(Object adaptee) {
		return new TimeSpanToThroughputHistogramAdapter((SensorAndMeasurements) adaptee);
	}

	public String getAdapterFactoryID() {
		return "TimeSpanSensorToThroughputHistrogramFactory";
	}
	
	public String getMetricLabel() {
		return "Throughput Histogram";
	}
}
