/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.impl;

import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DifferentDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionImpl;
import de.uka.ipd.sdq.probfunction.math.impl.SampleImpl;
import de.uka.ipd.sdq.probfunction.math.impl.ValueBasedComparator;
import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ProbabilityMassFunctionImpl
extends ProbabilityFunctionImpl
implements IProbabilityMassFunction {
    private List<ISample> samples;

    protected ProbabilityMassFunctionImpl(IUnit unit, boolean hasOrderedDomain, boolean isInFrequencyDomain) {
        this(new ArrayList<ISample>(), unit, hasOrderedDomain, isInFrequencyDomain);
    }

    protected ProbabilityMassFunctionImpl(List<ISample> samples, IUnit unit, boolean hasOrderedDomain, boolean isInFrequencyDomain) {
        this(samples, unit, hasOrderedDomain, isInFrequencyDomain, new DefaultRandomGenerator());
    }

    protected ProbabilityMassFunctionImpl(List<ISample> samples, IUnit unit, boolean hasOrderedDomain, boolean isInFrequencyDomain, IRandomGenerator generator) {
        super(unit, hasOrderedDomain, isInFrequencyDomain);
        Collections.sort(samples, MathTools.getSampleComparator());
        this.samples = samples;
        this.randomGenerator = generator;
    }

    private IProbabilityMassFunction performOperation(Operation op, IProbabilityMassFunction pmf1, IProbabilityMassFunction pmf2) {
        ArrayList<ISample> resultList = new ArrayList<ISample>();
        Iterator<ISample> iterator = pmf2.getSamples().iterator();
        for (ISample s1 : pmf1.getSamples()) {
            double result;
            ISample s2 = iterator.next();
            switch (op) {
                case ADD: {
                    result = s1.getProbability() + s2.getProbability();
                    break;
                }
                case SUB: {
                    result = s1.getProbability() - s2.getProbability();
                    break;
                }
                case MULT: {
                    result = s1.getProbability() * s2.getProbability();
                    break;
                }
                case DIV: {
                    result = s1.getProbability() / s2.getProbability();
                    break;
                }
                default: {
                    result = 0.0;
                }
            }
            resultList.add(pfFactory.createSample(s1.getValue(), result));
        }
        return pfFactory.createProbabilityMassFunction(resultList, this.getUnit(), this.hasOrderedDomain());
    }

    @Override
    public IProbabilityMassFunction add(IProbabilityMassFunction pmf) throws DifferentDomainsException {
        this.makeSameDomain(pmf);
        if (!this.haveSameDomain(pmf)) {
            throw new DifferentDomainsException();
        }
        return this.performOperation(Operation.ADD, this, pmf);
    }

    @Override
    public IProbabilityMassFunction mult(IProbabilityMassFunction pmf) throws DifferentDomainsException {
        this.makeSameDomain(pmf);
        if (!this.haveSameDomain(pmf)) {
            throw new DifferentDomainsException();
        }
        return this.performOperation(Operation.MULT, this, pmf);
    }

    @Override
    public IProbabilityMassFunction scale(double scalar) {
        ArrayList<ISample> newList = new ArrayList<ISample>();
        for (ISample sample : this.samples) {
            newList.add(pfFactory.createSample(sample.getValue(), sample.getProbability() * scalar));
        }
        return pfFactory.createProbabilityMassFunction(newList, this.getUnit(), this.hasOrderedDomain());
    }

    @Override
    public IProbabilityMassFunction div(IProbabilityMassFunction pmf) throws DifferentDomainsException {
        this.makeSameDomain(pmf);
        if (!this.haveSameDomain(pmf)) {
            throw new DifferentDomainsException();
        }
        return this.performOperation(Operation.DIV, this, pmf);
    }

    @Override
    public IProbabilityMassFunction sub(IProbabilityMassFunction pmf) throws DifferentDomainsException {
        this.makeSameDomain(pmf);
        if (!this.haveSameDomain(pmf)) {
            throw new DifferentDomainsException();
        }
        return this.performOperation(Operation.SUB, this, pmf);
    }

    private IProbabilityMassFunction makeSameDomain(IProbabilityMassFunction otherPMF) {
        List<ISample> valuesThis = this.samples;
        List<ISample> valuesOther = otherPMF.getSamples();
        if (valuesThis.size() == 0 && valuesOther.size() == 0) {
            return otherPMF;
        }
        if (valuesThis.size() == 0 && valuesOther.size() == 0) {
            throw new RuntimeException("Cannot adjust the domains of an empty PMF.");
        }
        List<Object> valuesToAddToThis = new ArrayList(valuesOther.size());
        List<Object> valuesToAddToOther = new ArrayList(valuesThis.size());
        ValueBasedComparator comparator = new ValueBasedComparator();
        Collections.sort(valuesThis, comparator);
        Collections.sort(valuesOther, comparator);
        valuesToAddToThis = this.getAllMissingSamples(valuesThis, valuesOther);
        valuesToAddToOther = this.getAllMissingSamples(valuesOther, valuesThis);
        valuesThis.addAll(valuesToAddToThis);
        valuesOther.addAll(valuesToAddToOther);
        Collections.sort(valuesThis, comparator);
        Collections.sort(valuesOther, comparator);
        otherPMF.setSamples(valuesOther);
        return otherPMF;
    }

    private List<ISample> getAllMissingSamples(List<ISample> valuesThis, List<ISample> valuesOther) {
        ArrayList<ISample> result = new ArrayList<ISample>();
        ValueBasedComparator comparator = new ValueBasedComparator();
        int indexOther = 0;
        ISample sampleOther = valuesOther.get(0);
        int indexThis = 0;
        while (indexThis < valuesThis.size()) {
            ISample sampleThis = valuesThis.get(indexThis);
            int compareResult = comparator.compare(sampleThis, sampleOther);
            if (compareResult >= 0) {
                if (compareResult > 0) {
                    result.add(new SampleImpl(sampleOther.getValue(), 0.0));
                    sampleOther = valuesOther.get(indexOther);
                    ++indexOther;
                    --indexThis;
                } else {
                    sampleOther = valuesOther.get(indexOther);
                    ++indexOther;
                }
            }
            if (indexOther >= valuesOther.size()) break;
            sampleOther = valuesOther.get(indexOther);
            ++indexThis;
        }
        int i = indexOther;
        while (i < valuesOther.size()) {
            result.add(new SampleImpl(valuesOther.get(i).getValue(), 0.0));
            ++i;
        }
        return result;
    }

    @Override
    public boolean haveSameDomain(IProbabilityMassFunction pmf) {
        List<ISample> values1 = this.samples;
        List<ISample> values2 = pmf.getSamples();
        if (values1.size() != values2.size()) {
            return false;
        }
        if (values1.size() == 0 && values2.size() == 0) {
            return true;
        }
        if (new ValueBasedComparator().compare(values1.get(0), values2.get(0)) != 0) {
            return false;
        }
        boolean result = true;
        Iterator<ISample> iterator = values2.iterator();
        for (ISample o : values1) {
            if (o.getValue().equals(iterator.next().getValue())) continue;
            result = false;
        }
        return result;
    }

    @Override
    public IProbabilityMassFunction getFourierTramsform() {
        return null;
    }

    @Override
    public IProbabilityMassFunction getInverseFourierTransform() {
        return null;
    }

    @Override
    public List<ISample> getSamples() {
        return new ArrayList<ISample>(this.samples);
    }

    @Override
    public void setSamples(List<ISample> samples) {
        if (samples.size() > 1 && samples.get(0).getValue() instanceof Comparable) {
            Collections.sort(samples, MathTools.getSampleComparator());
        }
        this.samples = samples;
    }

    @Override
    public double getArithmeticMeanValue() throws DomainNotNumbersException {
        double mean = 0.0;
        for (ISample sample : this.samples) {
            Number i;
            Object value = sample.getValue();
            if (value instanceof Double) {
                Double d = (Double)value;
                mean += d * sample.getProbability();
                continue;
            }
            if (value instanceof Integer) {
                i = (Integer)value;
                mean += (double)((Integer)i).intValue() * sample.getProbability();
                continue;
            }
            if (value instanceof Long) {
                i = (Long)value;
                mean += (double)((Long)i).longValue() * sample.getProbability();
                continue;
            }
            if (value instanceof Float) {
                i = (Float)value;
                mean += (double)((Float)i).floatValue() * sample.getProbability();
                continue;
            }
            throw new DomainNotNumbersException();
        }
        return mean;
    }

    @Override
    public Object getMedian() throws UnorderedDomainException {
        return this.getPercentile(50);
    }

    @Override
    public Object getPercentile(int p) throws IndexOutOfBoundsException, UnorderedDomainException {
        if (!this.hasOrderedDomain()) {
            throw new UnorderedDomainException();
        }
        if (p < 0 || p > 100) {
            throw new IndexOutOfBoundsException();
        }
        int rank = (int)Math.floor((double)p * ((double)this.samples.size() + 1.0) / 100.0);
        return this.samples.get(rank).getValue();
    }

    @Override
    public Object drawSample() {
        Object result = 0.0;
        List<Double> intervals = MathTools.computeCumulativeProbabilities(this.getProbabilities());
        double random = this.randomGenerator.random();
        int j = 0;
        while (j < intervals.size()) {
            if (random < intervals.get(j)) {
                result = this.samples.get(j).getValue();
                break;
            }
            ++j;
        }
        return result;
    }

    private List<Double> getProbabilities() {
        ArrayList<Double> prob = new ArrayList<Double>();
        for (ISample s : this.samples) {
            prob.add(s.getProbability());
        }
        return prob;
    }

    public boolean equals(Object obj) {
        if (((IProbabilityMassFunction)obj).getSamples().size() != this.samples.size()) {
            return false;
        }
        boolean result = true;
        Iterator<ISample> iterator = ((IProbabilityMassFunction)obj).getSamples().iterator();
        for (ISample o : this.getSamples()) {
            if (o.equals(iterator.next())) continue;
            result = false;
        }
        return result;
    }

    @Override
    public double getProbabilitySum() {
        double sum = 0.0;
        for (ISample sample : this.samples) {
            sum += sample.getProbability();
        }
        return sum;
    }

    @Override
    public void checkConstrains() throws ProbabilitySumNotOneException, InvalidSampleValueException, UnitNotSetException, UnitNameNotSetException {
        if (!MathTools.equalsDouble(this.getProbabilitySum(), 1.0)) {
            throw new ProbabilitySumNotOneException();
        }
        for (ISample sample : this.samples) {
            Object value = sample.getValue();
            if (value == null) {
                throw new InvalidSampleValueException();
            }
            if (!(sample.getProbability() < 0.0) && !(sample.getProbability() > 1.0)) continue;
            throw new InvalidSampleValueException();
        }
    }

    @Override
    public IProbabilityMassFunction getCumulativeFunction() {
        List<Double> newProb = MathTools.computeCumulativeProbabilities(this.getProbabilities());
        ArrayList<ISample> newSamples = new ArrayList<ISample>();
        int index = 0;
        for (Double d : newProb) {
            newSamples.add(pfFactory.createSample(this.samples.get(index).getValue(), d));
            ++index;
        }
        IProbabilityMassFunction pmf = null;
        pmf = pfFactory.createProbabilityMassFunction(newSamples, this.getUnit(), this.hasOrderedDomain());
        return pmf;
    }

    @Override
    public IProbabilityMassFunction shiftDomain(double scalar) throws DomainNotNumbersException {
        return this.transformDomainValues(scalar, Operation.SHIFT);
    }

    @Override
    public IProbabilityMassFunction stretchDomain(double scalar) throws DomainNotNumbersException {
        return this.transformDomainValues(scalar, Operation.STRETCH);
    }

    private IProbabilityMassFunction transformDomainValues(double scalar, Operation op) throws DomainNotNumbersException {
        ArrayList<ISample> resultList = new ArrayList<ISample>();
        Double factorDouble = scalar;
        Integer factorInteger = factorDouble.intValue();
        boolean factorIsInteger = factorDouble.doubleValue() == factorInteger.doubleValue();
        for (ISample sample : this.samples) {
            Object value = sample.getValue();
            Number resultValue = null;
            switch (op) {
                case SHIFT: {
                    Number valueNumber;
                    if (value instanceof Integer && factorIsInteger) {
                        resultValue = new Integer((Integer)value + factorInteger);
                        break;
                    }
                    if (value instanceof Long && factorIsInteger) {
                        resultValue = new Long((Long)value + (long)factorInteger.intValue());
                        break;
                    }
                    if (value instanceof Number) {
                        valueNumber = (Number)value;
                        resultValue = new Double(valueNumber.doubleValue() + factorDouble);
                        break;
                    }
                    throw new DomainNotNumbersException();
                }
                case STRETCH: {
                    Number valueNumber;
                    if (value instanceof Integer && factorIsInteger) {
                        resultValue = new Integer((Integer)value * factorInteger);
                        break;
                    }
                    if (value instanceof Long && factorIsInteger) {
                        resultValue = new Long((Long)value * (long)factorInteger.intValue());
                        break;
                    }
                    if (value instanceof Number) {
                        valueNumber = (Number)value;
                        resultValue = new Double(valueNumber.doubleValue() * factorDouble);
                        break;
                    }
                    throw new DomainNotNumbersException();
                }
                default: {
                    resultValue = 0.0;
                }
            }
            resultList.add(pfFactory.createSample(resultValue, sample.getProbability()));
        }
        return pfFactory.createProbabilityMassFunction(resultList, this.getUnit(), this.hasOrderedDomain());
    }

    private static enum Operation {
        ADD,
        SUB,
        MULT,
        DIV,
        SHIFT,
        STRETCH;

    }
}

