/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.impl;

import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.ExponentialDistribution;
import de.uka.ipd.sdq.probfunction.GammaDistribution;
import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.ProbfunctionFactory;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.SamplePDF;
import de.uka.ipd.sdq.probfunction.math.IBoxedPDF;
import de.uka.ipd.sdq.probfunction.math.IContinousPDF;
import de.uka.ipd.sdq.probfunction.math.IContinuousSample;
import de.uka.ipd.sdq.probfunction.math.IExponentialDistribution;
import de.uka.ipd.sdq.probfunction.math.IGammaDistribution;
import de.uka.ipd.sdq.probfunction.math.ILognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DoubleSampleException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.impl.BoxedPDFImpl;
import de.uka.ipd.sdq.probfunction.math.impl.ContinuousSampleImpl;
import de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.LognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityMassFunctionImpl;
import de.uka.ipd.sdq.probfunction.math.impl.SampleImpl;
import de.uka.ipd.sdq.probfunction.math.impl.SamplePDFImpl;
import de.uka.ipd.sdq.probfunction.math.impl.UnitImpl;
import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import flanagan.complex.Complex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ProbabilityFunctionFactoryImpl
implements IProbabilityFunctionFactory {
    public static final String DEFAULT_UNIT_NAME = "ms";
    private ProbfunctionFactory eFactory = ProbfunctionFactory.eINSTANCE;
    private static final IProbabilityFunctionFactory factoryInstance = new ProbabilityFunctionFactoryImpl();

    private ProbabilityFunctionFactoryImpl() {
    }

    @Override
    public IBoxedPDF transformToBoxedPDF(ProbabilityDensityFunction epdf) throws ProbabilitySumNotOneException, DoubleSampleException {
        return this.transformToBoxedPDF(epdf, new DefaultRandomGenerator());
    }

    @Override
    public IBoxedPDF transformToBoxedPDF(ProbabilityDensityFunction epdf, IRandomGenerator randomNumberGenerator) throws ProbabilitySumNotOneException, DoubleSampleException {
        ArrayList<IContinuousSample> samples;
        block3: {
            block2: {
                samples = new ArrayList<IContinuousSample>();
                if (!(epdf instanceof BoxedPDF)) break block2;
                for (Object s : ((BoxedPDF)epdf).getSamples()) {
                    samples.add(this.transformToContinuousSample((ContinuousSample)s));
                }
                break block3;
            }
            if (!(epdf instanceof SamplePDF)) break block3;
            int i = 1;
            for (Object v : ((SamplePDF)epdf).getValues()) {
                samples.add(this.createContinuousSample((double)i * ((SamplePDF)epdf).getDistance(), (Double)v));
                ++i;
            }
        }
        return this.createBoxedPDF(samples, randomNumberGenerator, null);
    }

    @Override
    public ISamplePDF transformToSamplePDF(ProbabilityDensityFunction epdf) throws UnknownPDFTypeException, ProbabilitySumNotOneException, DoubleSampleException {
        return this.transformToSamplePDF(epdf, new DefaultRandomGenerator());
    }

    public ISamplePDF transformToSamplePDF(ProbabilityDensityFunction epdf, IRandomGenerator randomGenerator) throws UnknownPDFTypeException, ProbabilitySumNotOneException, DoubleSampleException {
        if (epdf instanceof SamplePDF) {
            SamplePDF spdf = (SamplePDF)epdf;
            double distance = spdf.getDistance();
            ArrayList<Double> values = new ArrayList<Double>();
            return this.createSamplePDFFromDouble(distance, values, null, randomGenerator);
        }
        IBoxedPDF bpdf = this.transformToBoxedPDF(epdf, randomGenerator);
        return this.transformBoxedToSamplePDF(bpdf);
    }

    @Override
    public IProbabilityMassFunction transformToPMF(ProbabilityMassFunction epmf) {
        return this.transformToPMF(epmf, new DefaultRandomGenerator());
    }

    @Override
    public IProbabilityMassFunction transformToPMF(ProbabilityMassFunction epmf, IRandomGenerator randomGenerator) {
        boolean hasOrderedDomain = epmf.isOrderedDomain();
        ProbabilityMassFunctionImpl pmf = new ProbabilityMassFunctionImpl(new ArrayList<ISample>(), null, hasOrderedDomain, false, randomGenerator);
        ArrayList<ISample> samples = new ArrayList<ISample>();
        for (Object s : epmf.getSamples()) {
            Sample sample = (Sample)s;
            samples.add(this.transformToSample(sample));
        }
        pmf.setSamples(samples);
        return pmf;
    }

    @Override
    public IBoxedPDF createBoxedPDF(List<IContinuousSample> samples, IUnit unit) throws DoubleSampleException {
        return this.createBoxedPDF(samples, new DefaultRandomGenerator(), unit);
    }

    public IBoxedPDF createBoxedPDF(List<IContinuousSample> samples, IRandomGenerator randomGenerator, IUnit unit) throws DoubleSampleException {
        BoxedPDFImpl bpdf = new BoxedPDFImpl(unit, randomGenerator);
        bpdf.setSamples(samples);
        return bpdf;
    }

    public IBoxedPDF createBoxedPDF(List<IContinuousSample> samples, IUnit unit, IRandomGenerator generator) throws DoubleSampleException {
        BoxedPDFImpl bpdf = new BoxedPDFImpl(unit);
        bpdf.setSamples(samples);
        return new BoxedPDFImpl(unit, generator);
    }

    @Override
    public IContinuousSample createContinuousSample(double value, double d) {
        return new ContinuousSampleImpl(value, d);
    }

    @Override
    public IUnit createDefaultUnit() {
        return new UnitImpl(DEFAULT_UNIT_NAME);
    }

    @Override
    public ISamplePDF createDiracImpulse(int numOfSamplingPoints, double distance, IUnit unit) {
        return this.createImpulseAt(0, numOfSamplingPoints, distance, unit);
    }

    @Override
    public ISamplePDF createImpulseAt(int pos, int numOfSamplingPoints, double distance, IUnit unit) {
        assert (pos < numOfSamplingPoints);
        List<Complex> zeroList = this.createZeroList(numOfSamplingPoints);
        zeroList.get(pos).setReal(1.0);
        return this.createSamplePDFFromComplex(distance, zeroList, false, unit);
    }

    private List<Complex> createZeroList(int numOfSamplingPoints) {
        ArrayList<Complex> resultList = new ArrayList<Complex>();
        int i = 0;
        while (i < numOfSamplingPoints) {
            resultList.add(new Complex(0.0, 0.0));
            ++i;
        }
        return resultList;
    }

    @Override
    public IProbabilityMassFunction createProbabilityMassFunction(List<ISample> samples, IUnit unit, boolean hasOrderedDomain) {
        return new ProbabilityMassFunctionImpl(samples, unit, hasOrderedDomain, false);
    }

    @Override
    public IProbabilityMassFunction createPMFFromMeasurements(Boolean[] measurements, IUnit unit, boolean hasOrderedDomain) {
        HashMap<Boolean, Integer> times = new HashMap<Boolean, Integer>();
        List<Boolean> measurementsList = Arrays.asList(measurements);
        for (Boolean i : measurementsList) {
            int oldValue = times.get(i) == null ? 0 : (Integer)times.get(i);
            times.put(i, ++oldValue);
        }
        List<ISample> samples = this.createPMFFromList(times, measurementsList.size());
        return this.createProbabilityMassFunction(samples, unit, hasOrderedDomain);
    }

    @Override
    public IProbabilityMassFunction createPMFFromMeasurements(Double[] measurements, double epsilon, IUnit unit, boolean hasOrderedDomain) {
        HashMap<Double, Integer> times = new HashMap<Double, Integer>();
        List<Double> measurementsList = Arrays.asList(measurements);
        ArrayList<Integer> compared = new ArrayList<Integer>();
        int index1 = 0;
        for (Double d1 : measurementsList) {
            int index = 0;
            if (compared.contains(index1)) {
                ++index1;
                continue;
            }
            for (Double d2 : measurementsList) {
                if (Math.abs(d1 - d2) < epsilon && !compared.contains(index)) {
                    int oldValue = times.get(d1) == null ? 0 : (Integer)times.get(d1);
                    times.put(d1, ++oldValue);
                    compared.add(index);
                }
                ++index;
            }
            ++index1;
        }
        List<ISample> samples = this.createPMFFromList(times, measurementsList.size());
        return this.createProbabilityMassFunction(samples, unit, hasOrderedDomain);
    }

    @Override
    public IProbabilityMassFunction createPMFFromMeasurements(String[] measurements, IUnit unit, boolean hasOrderedDomain) {
        HashMap<String, Integer> times = new HashMap<String, Integer>();
        List<String> measurementsList = Arrays.asList(measurements);
        for (String i : measurementsList) {
            int oldValue = times.get(i) == null ? 0 : (Integer)times.get(i);
            times.put(i, ++oldValue);
        }
        List<ISample> samples = this.createPMFFromList(times, measurementsList.size());
        return this.createProbabilityMassFunction(samples, unit, hasOrderedDomain);
    }

    @Override
    public IProbabilityMassFunction createPMFFromMeasurements(Integer[] measurements, IUnit unit, boolean hasOrderedDomain) {
        HashMap<Integer, Integer> times = new HashMap<Integer, Integer>();
        List<Integer> measurementsList = Arrays.asList(measurements);
        for (Integer i : measurementsList) {
            int oldValue = times.get(i) == null ? 0 : (Integer)times.get(i);
            times.put(i, ++oldValue);
        }
        List<ISample> samples = this.createPMFFromList(times, measurementsList.size());
        return this.createProbabilityMassFunction(samples, unit, hasOrderedDomain);
    }

    private List<ISample> createPMFFromList(HashMap<? extends Object, Integer> map, int count) {
        ArrayList<ISample> samples = new ArrayList<ISample>();
        for (Object object : map.keySet()) {
            samples.add(this.createSample(object, (double)map.get(object).intValue() * 1.0 / (double)count));
        }
        return samples;
    }

    @Override
    public ISample createSample(Object value, double probability) {
        return new SampleImpl(value, probability);
    }

    @Override
    public ISamplePDF createSamplePDFFromComplex(double distance, List<Complex> values, IUnit unit) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit);
        spdf.setValues(values, false);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromComplex(double distance, List<Complex> samples, boolean isInFrequencyDomain, IUnit unit) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit, isInFrequencyDomain);
        spdf.setValues(samples, isInFrequencyDomain);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromComplex(double distance, List<Complex> samples, IUnit unit, IRandomGenerator generator) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit, generator);
        spdf.setValues(samples, false);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromComplex(double distance, List<Complex> samples, boolean isInFrequencyDomain, IUnit unit, IRandomGenerator generator) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit, isInFrequencyDomain, generator);
        spdf.setValues(samples, isInFrequencyDomain);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromDouble(double distance, List<Double> values, IUnit unit) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit);
        spdf.setValuesAsDouble(values);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromDouble(double distance, List<Double> values, boolean isInFrequencyDomain, IUnit unit) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit, isInFrequencyDomain);
        spdf.setValuesAsDouble(values);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromDouble(double distance, List<Double> values, IUnit unit, IRandomGenerator generator) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit, generator);
        spdf.setValuesAsDouble(values);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromDouble(double distance, List<Double> values, boolean isInFrequencyDomain, IUnit unit, IRandomGenerator generator) {
        SamplePDFImpl spdf = new SamplePDFImpl(distance, unit, isInFrequencyDomain, generator);
        spdf.setValuesAsDouble(values);
        return spdf;
    }

    @Override
    public ISamplePDF createSamplePDFFromMeasurements(double distance, List<Double> measurements, IUnit unit) {
        Collections.sort(measurements);
        ArrayList<Double> samples = new ArrayList<Double>();
        HashMap<Integer, Integer> timesMap = new HashMap<Integer, Integer>();
        int maxPos = 0;
        for (Double d : measurements) {
            int pos = (int)(d / distance);
            double rest = d % distance / distance;
            if (rest > 0.5) {
                ++pos;
            }
            maxPos = pos > maxPos ? pos : maxPos;
            Integer value = (Integer)timesMap.get(pos);
            if (value == null) {
                value = new Integer(0);
            }
            value = value + 1;
            timesMap.put(pos, value);
        }
        int i = 0;
        while (i <= maxPos) {
            Integer value = (Integer)timesMap.get(i);
            if (value == null) {
                samples.add(0.0);
            } else {
                samples.add((double)value.intValue() / (double)measurements.size());
            }
            ++i;
        }
        return this.createSamplePDFFromDouble(distance, samples, unit);
    }

    @Override
    public IUnit createUnit(String unitName) {
        return new UnitImpl(unitName);
    }

    @Override
    public ISamplePDF createZeroFunction(int numOfSamplingPoints, double distance, IUnit unit) {
        List<Complex> zeroList = this.createZeroList(numOfSamplingPoints);
        return this.createSamplePDFFromComplex(distance, zeroList, false, unit);
    }

    @Override
    public IBoxedPDF transformToBoxedPDF(IProbabilityDensityFunction pdf) throws UnknownPDFTypeException, DoubleSampleException, FunctionNotInTimeDomainException {
        IBoxedPDF resultPDF;
        if (pdf instanceof IBoxedPDF) {
            resultPDF = (IBoxedPDF)pdf;
        } else if (pdf instanceof ISamplePDF) {
            resultPDF = this.transformSampledToBoxedPDF((ISamplePDF)pdf);
        } else if (pdf instanceof IContinousPDF) {
            resultPDF = this.transformContinuousToBoxedPDF((IContinousPDF)pdf);
        } else {
            throw new UnknownPDFTypeException(pdf);
        }
        return resultPDF;
    }

    @Override
    public BoxedPDF transformToModelBoxedPDF(IProbabilityDensityFunction pdf) throws UnknownPDFTypeException, DoubleSampleException, FunctionNotInTimeDomainException {
        IBoxedPDF boxedPDF = this.transformToBoxedPDF(pdf);
        BoxedPDF ePDF = this.eFactory.createBoxedPDF();
        EList list = ePDF.getSamples();
        for (IContinuousSample s : boxedPDF.getSamples()) {
            list.add((Object)this.transformToModelContinuousSample(s));
        }
        return ePDF;
    }

    @Override
    public ProbabilityDensityFunction transformToModelPDF(IProbabilityDensityFunction pdf) throws UnknownPDFTypeException, DoubleSampleException, FunctionNotInTimeDomainException {
        SamplePDF ePDF;
        if (pdf instanceof ISamplePDF) {
            ePDF = this.transformToModelSamplePDF(pdf);
        } else if (pdf instanceof IBoxedPDF) {
            ePDF = this.transformToModelBoxedPDF(pdf);
        } else if (pdf instanceof IExponentialDistribution) {
            ExponentialDistribution expPDF = this.eFactory.createExponentialDistribution();
            expPDF.setRate(((IExponentialDistribution)pdf).getRate());
            ePDF = expPDF;
        } else if (pdf instanceof IGammaDistribution) {
            GammaDistribution gamma = this.eFactory.createGammaDistribution();
            gamma.setAlpha(((IGammaDistribution)pdf).getAlpha());
            gamma.setBeta(((IGammaDistribution)pdf).getBeta());
            ePDF = gamma;
        } else if (pdf instanceof ILognormalDistribution) {
            de.uka.ipd.sdq.probfunction.LognormalDistribution lognorm = this.eFactory.createLognormalDistribution();
            lognorm.setMu(((ILognormalDistribution)pdf).getMu());
            lognorm.setSigma(((ILognormalDistribution)pdf).getSigma());
            ePDF = lognorm;
        } else {
            throw new UnknownPDFTypeException(pdf);
        }
        return ePDF;
    }

    @Override
    public ProbabilityMassFunction transformToModelPMF(IProbabilityMassFunction pmf) {
        ProbabilityMassFunction epmf = this.eFactory.createProbabilityMassFunction();
        EList list = epmf.getSamples();
        for (ISample s : pmf.getSamples()) {
            list.add((Object)this.transformToModelSample(s));
        }
        epmf.setOrderedDomain(pmf.hasOrderedDomain());
        return epmf;
    }

    @Override
    public SamplePDF transformToModelSamplePDF(IProbabilityDensityFunction pdf) throws UnknownPDFTypeException {
        ISamplePDF samplePDF = this.transformToSamplePDF(pdf);
        SamplePDF ePDF = this.eFactory.createSamplePDF();
        EList list = ePDF.getValues();
        for (Complex d : samplePDF.getValues()) {
            list.add((Object)d.getReal());
        }
        ePDF.setDistance(samplePDF.getDistance());
        return ePDF;
    }

    @Override
    public IProbabilityDensityFunction transformToPDF(ProbabilityDensityFunction ePDF) throws UnknownPDFTypeException, ProbabilitySumNotOneException, DoubleSampleException {
        return this.transformToPDF(ePDF, new DefaultRandomGenerator());
    }

    @Override
    public IProbabilityDensityFunction transformToPDF(ProbabilityDensityFunction ePDF, IRandomGenerator randomGenerator) throws UnknownPDFTypeException, ProbabilitySumNotOneException, DoubleSampleException {
        IProbabilityDensityFunction pdf;
        if (ePDF instanceof SamplePDF) {
            pdf = this.transformToSamplePDF(ePDF, randomGenerator);
        } else if (ePDF instanceof BoxedPDF) {
            pdf = this.transformToBoxedPDF(ePDF, randomGenerator);
        } else if (ePDF instanceof ExponentialDistribution) {
            pdf = new de.uka.ipd.sdq.probfunction.math.impl.ExponentialDistribution(((ExponentialDistribution)ePDF).getRate());
        } else if (ePDF instanceof GammaDistribution) {
            pdf = new de.uka.ipd.sdq.probfunction.math.impl.GammaDistribution(((GammaDistribution)ePDF).getAlpha(), ((GammaDistribution)ePDF).getBeta());
        } else if (ePDF instanceof de.uka.ipd.sdq.probfunction.LognormalDistribution) {
            pdf = new LognormalDistribution(((de.uka.ipd.sdq.probfunction.LognormalDistribution)ePDF).getMu(), ((de.uka.ipd.sdq.probfunction.LognormalDistribution)ePDF).getSigma());
        } else {
            throw new UnknownPDFTypeException(ePDF);
        }
        return pdf;
    }

    @Override
    public ISamplePDF transformToSamplePDF(IProbabilityDensityFunction pdf) throws UnknownPDFTypeException {
        ISamplePDF resultPDF;
        if (pdf instanceof ISamplePDF) {
            resultPDF = (ISamplePDF)pdf;
        } else if (pdf instanceof IBoxedPDF) {
            resultPDF = this.transformBoxedToSamplePDF((IBoxedPDF)pdf);
        } else {
            if (pdf != null) {
                throw new UnknownPDFTypeException(pdf);
            }
            return null;
        }
        return resultPDF;
    }

    @Override
    public ISamplePDF transformToSamplePDF(IProbabilityDensityFunction pdf, double newDistance) throws UnknownPDFTypeException, NegativeDistanceException, FunctionNotInTimeDomainException {
        ISamplePDF resultPDF;
        if (pdf instanceof ISamplePDF) {
            resultPDF = ((ISamplePDF)pdf).getFunctionWithNewDistance(newDistance);
        } else if (pdf instanceof IBoxedPDF) {
            resultPDF = this.transformBoxedToSamplePDF((IBoxedPDF)pdf, newDistance);
        } else {
            if (pdf != null) {
                throw new UnknownPDFTypeException(pdf);
            }
            return null;
        }
        return resultPDF;
    }

    @Override
    public IContinuousSample transformToContinuousSample(ContinuousSample eSample) {
        IContinuousSample sample = this.createContinuousSample(eSample.getValue(), eSample.getProbability());
        return sample;
    }

    @Override
    public ContinuousSample transformToModelContinuousSample(IContinuousSample sample) {
        ContinuousSample eSample = this.eFactory.createContinuousSample();
        eSample.setProbability(sample.getProbability().doubleValue());
        eSample.setValue(sample.getValue());
        return eSample;
    }

    @Override
    public Sample transformToModelSample(ISample sample) {
        Sample eSample = this.eFactory.createSample();
        eSample.setProbability(sample.getProbability());
        eSample.setValue(sample.getValue());
        return eSample;
    }

    @Override
    public String transformToModelUnitSpecification(IUnit unit) {
        return unit.getUnitName();
    }

    @Override
    public ISample transformToSample(Sample eSample) {
        ISample sample = this.createSample(eSample.getValue(), eSample.getProbability());
        return sample;
    }

    @Override
    public IUnit transformToUnit(String unitSpecification) {
        IUnit unit = this.createDefaultUnit();
        unit.setUnitName(unitSpecification);
        return unit;
    }

    public static IProbabilityFunctionFactory getInstance() {
        return factoryInstance;
    }

    private ISamplePDF transformBoxedToSamplePDF(IBoxedPDF pdf) {
        List<Double> values = this.continuousSamplesToDoubles(pdf.getSamples());
        ArrayList<Double> newValues = new ArrayList<Double>();
        double distance = MathTools.gcd(values);
        double halfDistance = distance / 2.0;
        double start = 0.0;
        int flag = 1;
        double np = 0.0;
        for (IContinuousSample s : pdf.getSamples()) {
            int times = (int)Math.round((s.getValue() - start) / halfDistance);
            int i = 0;
            while (i < times) {
                if (flag == 1) {
                    newValues.add(np += s.getProbability() / (double)times);
                    flag = 0;
                } else {
                    np = s.getProbability() / (double)times;
                    ++flag;
                }
                ++i;
            }
            start = s.getValue();
        }
        if (flag == 1) {
            newValues.add(np);
        }
        return this.createSamplePDFFromDouble(distance, newValues, pdf.getUnit());
    }

    public ISamplePDF transformBoxedToSamplePDF(IBoxedPDF bpdf, double distance) {
        if (bpdf.getSamples().size() == 0) {
            return this.createSamplePDFFromComplex(distance, new ArrayList<Complex>(), bpdf.getUnit());
        }
        double maxValue = bpdf.getSamples().get(bpdf.getSamples().size() - 1).getValue();
        double currentNewSample = distance / 2.0;
        int index = 0;
        List<IContinuousSample> samples = bpdf.getSamples();
        ArrayList<Double> newSamples = new ArrayList<Double>();
        double newProb = 0.0;
        while (currentNewSample < maxValue || index < samples.size()) {
            double usedXLengthOfBox;
            double totalXLengthOfBox;
            if (currentNewSample < samples.get(index).getValue()) {
                if (newSamples.size() == 0) {
                    newProb = currentNewSample / samples.get(0).getValue() * samples.get(0).getProbability();
                } else {
                    double dif = index == 0 ? samples.get(0).getValue() : samples.get(index).getValue() - samples.get(index - 1).getValue();
                    newProb = distance / dif * samples.get(index).getProbability();
                }
                newSamples.add(newProb);
                currentNewSample += distance;
                continue;
            }
            double fractionOfBox = 0.0;
            if (index == 0) {
                totalXLengthOfBox = samples.get(index).getValue();
                usedXLengthOfBox = samples.get(index).getValue() - currentNewSample + distance;
                fractionOfBox = Math.min(1.0, usedXLengthOfBox / totalXLengthOfBox);
            } else {
                totalXLengthOfBox = samples.get(index).getValue() - samples.get(index - 1).getValue();
                usedXLengthOfBox = samples.get(index).getValue() - currentNewSample + distance;
                fractionOfBox = usedXLengthOfBox / totalXLengthOfBox;
            }
            newProb = fractionOfBox * samples.get(index).getProbability();
            ++index;
            while (index < samples.size() && samples.get(index).getValue() < currentNewSample) {
                newProb += samples.get(index).getProbability().doubleValue();
                ++index;
            }
            if (index < samples.size()) {
                newProb += (1.0 - (samples.get(index).getValue() - currentNewSample) / (samples.get(index).getValue() - samples.get(index - 1).getValue())) * samples.get(index).getProbability();
            }
            newSamples.add(newProb);
            currentNewSample += distance;
        }
        return this.createSamplePDFFromDouble(distance, newSamples, false, bpdf.getUnit());
    }

    private IBoxedPDF transformSampledToBoxedPDF(ISamplePDF spdf) throws DoubleSampleException, FunctionNotInTimeDomainException {
        if (spdf.isInFrequencyDomain()) {
            throw new FunctionNotInTimeDomainException();
        }
        List<Double> values = spdf.getValuesAsDouble();
        ArrayList<IContinuousSample> samples = new ArrayList<IContinuousSample>();
        double distance = spdf.getDistance();
        int i = 0;
        while (i < values.size()) {
            double currentProb;
            double prob = currentProb = values.get(i).doubleValue();
            ++i;
            while (i < values.size()) {
                double nextProb = values.get(i);
                if (!MathTools.equalsDouble(nextProb, currentProb)) break;
                prob += nextProb;
                ++i;
            }
            IContinuousSample s = this.createContinuousSample(distance * (double)i, prob);
            samples.add(s);
        }
        return this.createBoxedPDF(samples, spdf.getUnit());
    }

    private IBoxedPDF transformContinuousToBoxedPDF(IContinousPDF pdf) throws DoubleSampleException {
        int numberOfBoxes = 20;
        double cutMargin = 0.05;
        double xSup = pdf.getXsup();
        double xInf = pdf.getXinf();
        if (Double.isInfinite(xSup) || Double.isNaN(xSup)) {
            xSup = pdf.inverseF(1.0 - cutMargin);
        }
        if (Double.isInfinite(xInf) || Double.isNaN(xInf)) {
            xInf = pdf.inverseF(0.0 + cutMargin);
        }
        double stepwidth = (xSup - xInf) / 20.0;
        double x = xInf;
        double upperProbability = 0.0;
        double lowerProbability = 0.0;
        ArrayList<IContinuousSample> samples = new ArrayList<IContinuousSample>();
        if (xInf != 0.0) {
            IContinuousSample s = this.createContinuousSample(xInf, 0.0);
            samples.add(s);
        }
        int i = 1;
        while (i <= numberOfBoxes) {
            x = xInf + (double)i * stepwidth;
            lowerProbability = upperProbability;
            upperProbability = pdf.cdf(x);
            IContinuousSample s = this.createContinuousSample(x, upperProbability - lowerProbability);
            samples.add(s);
            ++i;
        }
        BoxedPDFImpl boxedPdf = (BoxedPDFImpl)this.createBoxedPDF(samples, pdf.getUnit());
        double sum = boxedPdf.getProbabilitySum();
        if (Math.abs(sum - 1.0) > 1.0E-9) {
            double delta = (1.0 - sum) / this.countNonZeroContiniousSamples(samples);
            for (IContinuousSample sample : boxedPdf.getSamples()) {
                if (!(sample.getProbability() > 0.0)) continue;
                ((ContinuousSampleImpl)sample).setProbability(sample.getProbability() + delta);
            }
        }
        return boxedPdf;
    }

    private double countNonZeroContiniousSamples(List<IContinuousSample> samples) {
        int count = 0;
        for (IContinuousSample s : samples) {
            if (!(s.getProbability() > 0.0)) continue;
            ++count;
        }
        return count;
    }

    private List<Double> continuousSamplesToDoubles(List<IContinuousSample> list) {
        ArrayList<Double> newList = new ArrayList<Double>();
        double start = 0.0;
        for (IContinuousSample s : list) {
            newList.add(s.getValue() - start);
            start = s.getValue();
        }
        return newList;
    }
}

