/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.test;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Before;

public class SamplePDFTest {
    private ISamplePDF df1;
    private ISamplePDF df2;
    private ISamplePDF df3;
    private IProbabilityFunctionFactory dfFactory = IProbabilityFunctionFactory.eINSTANCE;

    private ISamplePDF createSamplePDF(double distance, Double[] values) {
        return this.dfFactory.createSamplePDFFromDouble(distance, Arrays.asList(values), this.dfFactory.createDefaultUnit());
    }

    @Before
    public void setUp() {
        this.df1 = this.createSamplePDF(10.0, new Double[]{0.1, 0.2, 0.4, 0.3});
        this.df2 = this.createSamplePDF(10.0, new Double[]{0.0, 0.2, 0.1, 0.2, 0.3, 0.2});
        this.df3 = this.createSamplePDF(10.0, new Double[]{0.0, 0.2, 0.05, 0.15, 0.3, 0.2, 0.07, 0.03, 0.0});
    }

    @org.junit.Test
    public void timeDomain() throws FunctionNotInTimeDomainException {
        Assert.assertTrue((boolean)this.df1.isInTimeDomain());
        Assert.assertTrue((boolean)this.df2.isInTimeDomain());
        Assert.assertFalse((boolean)this.df1.isInFrequencyDomain());
        IProbabilityDensityFunction pdf = this.df1.getFourierTransform();
        Assert.assertFalse((boolean)pdf.isInTimeDomain());
        Assert.assertTrue((boolean)pdf.isInFrequencyDomain());
    }

    @org.junit.Test
    public void equals() {
        Assert.assertTrue((boolean)this.df1.equals(this.df1));
        ISamplePDF df1copy = this.createSamplePDF(10.0, new Double[]{0.1, 0.2, 0.4, 0.3});
        Assert.assertTrue((boolean)this.df1.equals(df1copy));
        ISamplePDF df1LongCopy = this.createSamplePDF(10.0, new Double[]{0.1, 0.2, 0.4, 0.3, 0.0});
        Assert.assertTrue((boolean)this.df1.equals(df1LongCopy));
        ISamplePDF df1LongWrongCopy = this.createSamplePDF(10.0, new Double[]{0.1, 0.2, 0.4, 0.3, 0.0, 0.01});
        Assert.assertFalse((boolean)this.df1.equals(df1LongWrongCopy));
        Assert.assertFalse((boolean)this.df2.equals(this.df1));
        ISamplePDF df1WrongCopy = this.createSamplePDF(10.0, new Double[]{0.2, 0.1, 0.4, 0.3});
        Assert.assertFalse((boolean)this.df1.equals(df1WrongCopy));
    }

    @org.junit.Test
    public void scale() {
        IProbabilityDensityFunction df1scale = this.df1.scale(0.1);
        ISamplePDF spdf = this.createSamplePDF(10.0, new Double[]{0.01, 0.02, 0.04, 0.03});
        Assert.assertEquals((Object)spdf, (Object)df1scale);
    }

    @org.junit.Test
    public void adjustDistance() throws NegativeDistanceException, FunctionNotInTimeDomainException {
        ISamplePDF pdf = this.df1.getFunctionWithNewDistance(10.0);
        Assert.assertEquals((Object)this.df1, (Object)pdf);
        pdf = this.df1.getFunctionWithNewDistance(5.0);
        ISamplePDF expected = this.createSamplePDF(5.0, new Double[]{0.05, 0.1, 0.1, 0.15, 0.2, 0.175, 0.15, 0.075});
        Assert.assertEquals((Object)expected, (Object)pdf);
        pdf = this.df1.getFunctionWithNewDistance(7.0);
        expected = this.createSamplePDF(7.0, new Double[]{0.07, 0.14, 0.19, 0.28, 0.215, 0.105});
        Assert.assertEquals((Object)expected, (Object)pdf);
        pdf = this.df1.getFunctionWithNewDistance(15.0);
        expected = this.createSamplePDF(15.0, new Double[]{0.15, 0.45, 0.4});
        Assert.assertEquals((Object)expected, (Object)pdf);
        pdf = this.df1.getFunctionWithNewDistance(13.0);
        expected = this.createSamplePDF(13.0, new Double[]{0.13, 0.35, 0.445, 0.075});
        Assert.assertEquals((Object)expected, (Object)pdf);
    }

    @org.junit.Test
    public void add() throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        IProbabilityDensityFunction sum = this.df1.add((IProbabilityDensityFunction)this.df1);
        ISamplePDF sumExpected = this.createSamplePDF(10.0, new Double[]{0.2, 0.4, 0.8, 0.6});
        Assert.assertEquals((Object)sumExpected, (Object)sum);
        sum = this.df1.add((IProbabilityDensityFunction)this.df3);
        sumExpected = this.createSamplePDF(10.0, new Double[]{0.1, 0.4, 0.45, 0.45, 0.3, 0.2, 0.07, 0.03, 0.0});
        Assert.assertEquals((Object)sumExpected, (Object)sum);
        ISamplePDF pdf = this.createSamplePDF(5.0, new Double[]{0.05, 0.05, 0.1, 0.1, 0.2, 0.2, 0.15, 0.15});
        sum = this.df1.add((IProbabilityDensityFunction)pdf);
        sumExpected = this.createSamplePDF(5.0, new Double[]{0.1, 0.15, 0.2, 0.25, 0.4, 0.375, 0.3, 0.225});
        Assert.assertEquals((Object)sumExpected, (Object)sum);
    }

    @org.junit.Test
    public void mult() throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        IProbabilityDensityFunction prod = this.df1.mult((IProbabilityDensityFunction)this.df1);
        ISamplePDF expected = this.createSamplePDF(10.0, new Double[]{0.01, 0.04, 0.16, 0.09});
        Assert.assertEquals((Object)expected, (Object)prod);
    }

    @org.junit.Test
    public void checkConstraints() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        this.df1.checkConstrains();
        this.df2.checkConstrains();
        this.df3.checkConstrains();
    }

    @org.junit.Test(expected=NegativeDistanceException.class)
    public void checkConstraints1() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        ISamplePDF s = this.createSamplePDF(-1.0, new Double[]{0.1, 0.4, 0.2, 0.3, 0.2});
        s.checkConstrains();
    }

    @org.junit.Test(expected=ProbabilitySumNotOneException.class)
    public void checkConstraints2() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        ISamplePDF s = this.createSamplePDF(1.0, new Double[]{0.1, 0.4, 0.2, 0.3, 0.2});
        s.checkConstrains();
    }

    @org.junit.Test(expected=InvalidSampleValueException.class)
    public void checkConstraints3() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        ISamplePDF s = this.createSamplePDF(1.0, new Double[]{0.1, -0.4, 0.2, 1.1});
        s.checkConstrains();
    }

    @org.junit.Test(expected=UnitNotSetException.class)
    public void checkConstraints4() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        ArrayList samples = new ArrayList();
        Collections.addAll(samples, 0.1, 0.4, 0.2, 0.1);
        ISamplePDF s = this.dfFactory.createSamplePDFFromDouble(1.0, samples, null);
        s.checkConstrains();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(SamplePDFTest.class);
    }
}

