/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.test;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DifferentDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProbabilityMassFunctionTest {
    IProbabilityMassFunction u1;
    IProbabilityMassFunction u1extended;
    IProbabilityMassFunction u1exDiffProbs;
    IProbabilityMassFunction u1same;
    IProbabilityMassFunction u2;
    IProbabilityMassFunction o1;
    IProbabilityMassFunction o1extended;
    IProbabilityMassFunction o1exDiffProbs;
    IProbabilityMassFunction o1same;
    IProbabilityMassFunction o2;
    private IProbabilityFunctionFactory dfFactory = IProbabilityFunctionFactory.eINSTANCE;

    @Before
    public void setUp() throws Exception {
        this.u1 = this.createPMF(new Object[]{"car", 0.1, "house", 0.5, "bike", 0.3, "street", 0.1}, false);
        this.u1same = this.createPMF(new Object[]{"car", 0.2, "house", 0.3, "bike", 0.4, "street", 0.1}, false);
        this.u1extended = this.createPMF(new Object[]{"car", 0.1, "house", 0.5, "bike", 0.3, "street", 0.1, "tree", 0.0}, false);
        this.u1exDiffProbs = this.createPMF(new Object[]{"car", 0.1, "house", 0.15, "bike", 0.3, "street", 0.1, "tree", 3.5}, false);
        this.u2 = this.createPMF(new Object[]{"dog", 0.2, "cat", 0.3, "pig", 0.4, "cow", 0.1}, false);
        this.o1 = this.createPMF(new Object[]{0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.1}, true);
        this.o1same = this.createPMF(new Object[]{0.1, 0.1, 0.2, 0.4, 0.3, 0.2, 0.4, 0.3}, true);
        this.o1extended = this.createPMF(new Object[]{0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.1, 0.5, 0.0}, true);
        this.o1exDiffProbs = this.createPMF(new Object[]{0.1, 0.1, 0.2, 0.15, 0.3, 0.25, 0.4, 0.3, 0.5, 0.1}, true);
        this.o2 = this.createPMF(new Object[]{0.2, 0.2, 0.4, 0.3, 0.6, 0.4, 0.8, 0.1}, true);
    }

    @Test
    public void testCreatePMF() {
        Assert.assertEquals((int)4, (int)this.o1.getSamples().size());
        Assert.assertEquals((int)4, (int)this.u1.getSamples().size());
        Assert.assertEquals((int)5, (int)this.u1extended.getSamples().size());
    }

    @Test
    public void equalsUnordered() {
        Assert.assertTrue((boolean)this.u1.equals(this.u1));
        IProbabilityMassFunction u1copy = this.createPMF(new Object[]{"car", 0.1, "house", 0.5, "bike", 0.3, "street", 0.1}, false);
        Assert.assertTrue((boolean)this.u1.equals(u1copy));
        Assert.assertFalse((boolean)this.u1.equals(this.u1same));
        Assert.assertFalse((boolean)this.u1.equals(this.u2));
        Assert.assertFalse((boolean)this.u1extended.equals(this.u1exDiffProbs));
        Assert.assertFalse((boolean)this.u1.equals(this.u1extended));
    }

    @Test
    public void equalsOrdered() {
        Assert.assertTrue((boolean)this.o1.equals(this.o1));
        IProbabilityMassFunction o1copy = this.createPMF(new Object[]{0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.1}, true);
        Assert.assertTrue((boolean)this.o1.equals(o1copy));
        Assert.assertFalse((boolean)this.o1.equals(this.o1same));
        Assert.assertFalse((boolean)this.o1.equals(this.o2));
        Assert.assertFalse((boolean)this.o1extended.equals(this.o1exDiffProbs));
        Assert.assertFalse((boolean)this.o1.equals(this.o1extended));
    }

    @Test
    public void hasOrderDomain() {
        Assert.assertTrue((boolean)this.o1.hasOrderedDomain());
        Assert.assertFalse((boolean)this.u1.hasOrderedDomain());
    }

    @Test(expected=UnorderedDomainException.class)
    public void unorderedGetMedian() throws UnorderedDomainException {
        this.u1.getMedian();
    }

    @Test(expected=UnorderedDomainException.class)
    public void unorderedPercentile() throws UnorderedDomainException {
        this.u1.getPercentile(10);
    }

    @Test
    public void percentile() throws IndexOutOfBoundsException, UnorderedDomainException {
        Assert.assertEquals((Object)0.3, (Object)this.o1.getPercentile(50));
    }

    @Test
    public void getMedian() throws UnorderedDomainException {
        Assert.assertEquals((Object)0.3, (Object)this.o1.getMedian());
    }

    @Test
    public void addSameDom() throws DifferentDomainsException {
        IProbabilityMassFunction sum = this.o1.add(this.o1same);
        IProbabilityMassFunction expected = this.createPMF(new Object[]{0.1, 0.3, 0.2, 0.7, 0.3, 0.6, 0.4, 0.4}, true);
        Assert.assertEquals((Object)expected, (Object)sum);
        sum = this.u1.add(this.u1same);
        expected = this.createPMF(new Object[]{"car", 0.3, "house", 0.8, "bike", 0.7, "street", 0.2}, true);
        Assert.assertEquals((Object)expected, (Object)sum);
        IProbabilityMassFunction unsorted = this.createPMF(new Object[]{"car", 0.2, "street", 0.1, "house", 0.3, "bike", 0.4}, false);
        sum = this.u1.add(unsorted);
        expected = this.createPMF(new Object[]{"house", 0.8, "bike", 0.7, "car", 0.3, "street", 0.2}, true);
        Assert.assertEquals((Object)expected, (Object)sum);
    }

    @Test(expected=DifferentDomainsException.class)
    public void addExtendedDomOrdered() throws DifferentDomainsException {
        this.o1.add(this.o1extended);
    }

    @Test(expected=DifferentDomainsException.class)
    public void addExtendedDomUnOrdered() throws DifferentDomainsException {
        this.u1.add(this.u1extended);
    }

    @Test(expected=DifferentDomainsException.class)
    public void addOrderedUnOrdered() throws DifferentDomainsException {
        this.o1.add(this.u1);
    }

    @Test
    public void multSameDom() throws DifferentDomainsException {
        IProbabilityMassFunction sum = this.o1.mult(this.o1same);
        IProbabilityMassFunction expected = this.createPMF(new Object[]{0.1, 0.02, 0.2, 0.12, 0.3, 0.08, 0.4, 0.03}, true);
        Assert.assertEquals((Object)expected, (Object)sum);
        sum = this.u1.mult(this.u1same);
        expected = this.createPMF(new Object[]{"car", 0.020000000000000004, "house", 0.15, "bike", 0.12, "street", 0.010000000000000002}, false);
        Assert.assertEquals((Object)expected, (Object)sum);
    }

    @Test
    public void scale() {
        IProbabilityMassFunction result = this.u1.scale(0.1);
        IProbabilityMassFunction expected = this.createPMF(new Object[]{"car", 0.01, "house", 0.05, "bike", 0.03, "street", 0.01}, false);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test(expected=DifferentDomainsException.class)
    public void multExtendedDomOrdered() throws DifferentDomainsException {
        this.o1.add(this.o1extended);
    }

    @Test(expected=DifferentDomainsException.class)
    public void multExtendedDomUnOrdered() throws DifferentDomainsException {
        this.u1.add(this.u1extended);
    }

    @Test(expected=DifferentDomainsException.class)
    public void multOrderedUnOrdered() throws DifferentDomainsException {
        this.o1.add(this.u1);
    }

    @Test(expected=ProbabilitySumNotOneException.class)
    public void checkConstrains1() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        IProbabilityMassFunction pmf = this.createPMF(new Object[]{0.1, 0.3, 0.2, 0.3, 0.3, 0.4, 0.4, 0.1}, true);
        pmf.checkConstrains();
    }

    @Test(expected=InvalidSampleValueException.class)
    public void checkConstrains3() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        IProbabilityMassFunction pmf = this.createPMF(new Object[]{0.1, 0.3, 0.2, 0.4, 0.4, 0.4, 0.4, -0.1}, true);
        pmf.checkConstrains();
    }

    @Test
    public void checkConstrains4() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        this.u1.checkConstrains();
        this.o1.checkConstrains();
        this.u1extended.checkConstrains();
    }

    private IProbabilityMassFunction createPMF(Object[] samples, boolean isOrderedSet) {
        ArrayList<ISample> sList = new ArrayList<ISample>();
        int i = 0;
        while (i < samples.length) {
            ISample s = this.dfFactory.createSample(samples[i], ((Double)samples[i + 1]).doubleValue());
            sList.add(s);
            i += 2;
        }
        IUnit ms = this.dfFactory.createUnit("ms");
        IProbabilityMassFunction pmf = this.dfFactory.createProbabilityMassFunction(sList, ms, isOrderedSet);
        return pmf;
    }
}

