/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.test;

import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.ProbfunctionFactory;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.math.IBoxedPDF;
import de.uka.ipd.sdq.probfunction.math.IContinuousSample;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DoubleSampleException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.impl.ExponentialDistribution;
import de.uka.ipd.sdq.probfunction.math.impl.GammaDistribution;
import de.uka.ipd.sdq.probfunction.math.impl.LognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionFactoryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import org.eclipse.emf.common.util.EList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProbabilityFunctionFactoryTest {
    private IBoxedPDF boxed;
    private double err = 1.0E-10;
    private IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    private ProbfunctionFactory epfFactory = ProbfunctionFactory.eINSTANCE;

    @Before
    public void setUp() {
    }

    @Test
    public void boxedToSamplePDF() {
        ISamplePDF samplePDF;
        ArrayList samples = new ArrayList();
        Collections.addAll(samples, this.pfFactory.createContinuousSample(0.9, 0.3), this.pfFactory.createContinuousSample(1.5, 0.4), this.pfFactory.createContinuousSample(1.8, 0.2), this.pfFactory.createContinuousSample(2.4, 0.1));
        try {
            this.boxed = this.pfFactory.createBoxedPDF(samples, null);
        }
        catch (DoubleSampleException e1) {
            e1.printStackTrace();
        }
        try {
            samplePDF = this.pfFactory.transformToSamplePDF((IProbabilityDensityFunction)this.boxed);
            Assert.assertTrue((Math.abs(samplePDF.getDistance() - 0.3) < this.err ? 1 : 0) != 0);
            Assert.assertEquals((long)samplePDF.getValuesAsDouble().size(), (long)9L);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(0) - 0.049999999999999996) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(1) - 0.09999999999999999) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(2) - 0.09999999999999999) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(3) - 0.15) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(4) - 0.2) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(5) - 0.2) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(6) - 0.125) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(7) - 0.05) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(7) - 0.05) < this.err ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(8) - 0.025) < this.err ? 1 : 0) != 0);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
        }
        samplePDF = ((ProbabilityFunctionFactoryImpl)this.pfFactory).transformBoxedToSamplePDF(this.boxed, 0.5);
        Assert.assertTrue((Math.abs(samplePDF.getDistance() - 0.5) < this.err ? 1 : 0) != 0);
        Assert.assertEquals((long)samplePDF.getValuesAsDouble().size(), (long)6L);
        Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(0) - 0.08333333333333333) < this.err ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(1) - 0.16666666666666666) < this.err ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(2) - 0.2833333333333333) < this.err ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(3) - 0.33333333333333337) < this.err ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(4) - 0.10833333333333335) < this.err ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)samplePDF.getValuesAsDouble().get(5) - 0.025) < this.err ? 1 : 0) != 0);
    }

    @Test
    public void iPMFToPMF() {
        IProbabilityMassFunction iProbFunc = this.pfFactory.createProbabilityMassFunction(this.getTestSamples(), this.getTestUnit(), true);
        ProbabilityMassFunction probFunc = this.pfFactory.transformToModelPMF(iProbFunc);
        Sample sample0 = (Sample)probFunc.getSamples().get(0);
        Assert.assertTrue(((Integer)sample0.getValue() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((sample0.getProbability() == 0.1 ? 1 : 0) != 0);
        Sample sample1 = (Sample)probFunc.getSamples().get(1);
        Assert.assertTrue(((Integer)sample1.getValue() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((sample1.getProbability() == 0.3 ? 1 : 0) != 0);
        Sample sample2 = (Sample)probFunc.getSamples().get(2);
        Assert.assertTrue(((Integer)sample2.getValue() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((sample2.getProbability() == 0.5 ? 1 : 0) != 0);
        Sample sample3 = (Sample)probFunc.getSamples().get(3);
        Assert.assertTrue(((Integer)sample3.getValue() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((sample3.getProbability() == 0.1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)probFunc.isOrderedDomain());
        iProbFunc = this.pfFactory.transformToPMF(probFunc);
        ISample s0 = (ISample)iProbFunc.getSamples().get(0);
        Assert.assertTrue(((Integer)s0.getValue() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s0.getProbability() == 0.1 ? 1 : 0) != 0);
        ISample s1 = (ISample)iProbFunc.getSamples().get(1);
        Assert.assertTrue(((Integer)s1.getValue() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s1.getProbability() == 0.3 ? 1 : 0) != 0);
        ISample s2 = (ISample)iProbFunc.getSamples().get(2);
        Assert.assertTrue(((Integer)s2.getValue() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((s2.getProbability() == 0.5 ? 1 : 0) != 0);
        ISample s3 = (ISample)iProbFunc.getSamples().get(3);
        Assert.assertTrue(((Integer)s3.getValue() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((s3.getProbability() == 0.1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iProbFunc.hasOrderedDomain());
    }

    @Test
    public void ePMFToIPMF() {
        ProbabilityMassFunction epmf = this.epfFactory.createProbabilityMassFunction();
        epmf.setOrderedDomain(true);
        this.initTestESamples(epmf.getSamples());
        IProbabilityMassFunction pmf = this.pfFactory.transformToPMF(epmf);
        ISample sample0 = (ISample)pmf.getSamples().get(0);
        Assert.assertTrue(((Integer)sample0.getValue() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((sample0.getProbability() == 0.1 ? 1 : 0) != 0);
        ISample sample1 = (ISample)pmf.getSamples().get(1);
        Assert.assertTrue(((Integer)sample1.getValue() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((sample1.getProbability() == 0.3 ? 1 : 0) != 0);
        ISample sample2 = (ISample)pmf.getSamples().get(2);
        Assert.assertTrue(((Integer)sample2.getValue() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((sample2.getProbability() == 0.5 ? 1 : 0) != 0);
        ISample sample3 = (ISample)pmf.getSamples().get(3);
        Assert.assertTrue(((Integer)sample3.getValue() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((sample3.getProbability() == 0.1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pmf.hasOrderedDomain());
    }

    @Test
    public void eBoxedPDFToIBoxedPDF() throws ProbabilitySumNotOneException, DoubleSampleException {
        BoxedPDF ebpdf = this.epfFactory.createBoxedPDF();
        this.initTestEContinuousSamples(ebpdf.getSamples());
        IBoxedPDF bpdf = this.pfFactory.transformToBoxedPDF((ProbabilityDensityFunction)ebpdf);
        IContinuousSample sample0 = (IContinuousSample)bpdf.getSamples().get(0);
        Assert.assertTrue((sample0.getValue() == 2.1 ? 1 : 0) != 0);
        Assert.assertTrue((sample0.getProbability() == 0.1 ? 1 : 0) != 0);
        IContinuousSample sample1 = (IContinuousSample)bpdf.getSamples().get(1);
        Assert.assertTrue((sample1.getValue() == 3.5 ? 1 : 0) != 0);
        Assert.assertTrue((sample1.getProbability() == 0.3 ? 1 : 0) != 0);
        IContinuousSample sample2 = (IContinuousSample)bpdf.getSamples().get(2);
        Assert.assertTrue((sample2.getValue() == 6.2 ? 1 : 0) != 0);
        Assert.assertTrue((sample2.getProbability() == 0.5 ? 1 : 0) != 0);
        IContinuousSample sample3 = (IContinuousSample)bpdf.getSamples().get(3);
        Assert.assertTrue((sample3.getValue() == 6.7 ? 1 : 0) != 0);
        Assert.assertTrue((sample3.getProbability() == 0.1 ? 1 : 0) != 0);
        try {
            ebpdf = this.pfFactory.transformToModelBoxedPDF((IProbabilityDensityFunction)bpdf);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
        }
        catch (FunctionNotInTimeDomainException e) {
            e.printStackTrace();
        }
        ContinuousSample s0 = (ContinuousSample)ebpdf.getSamples().get(0);
        Assert.assertTrue((s0.getValue() == 2.1 ? 1 : 0) != 0);
        Assert.assertTrue((s0.getProbability() == 0.1 ? 1 : 0) != 0);
        ContinuousSample s1 = (ContinuousSample)ebpdf.getSamples().get(1);
        Assert.assertTrue((s1.getValue() == 3.5 ? 1 : 0) != 0);
        Assert.assertTrue((s1.getProbability() == 0.3 ? 1 : 0) != 0);
        ContinuousSample s2 = (ContinuousSample)ebpdf.getSamples().get(2);
        Assert.assertTrue((s2.getValue() == 6.2 ? 1 : 0) != 0);
        Assert.assertTrue((s2.getProbability() == 0.5 ? 1 : 0) != 0);
        ContinuousSample s3 = (ContinuousSample)ebpdf.getSamples().get(3);
        Assert.assertTrue((s3.getValue() == 6.7 ? 1 : 0) != 0);
        Assert.assertTrue((s3.getProbability() == 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void createISamplePDF() {
        ArrayList samples = new ArrayList();
        Collections.addAll(samples, 0.1, 0.3, 0.2, 0.2, 0.2);
        ISamplePDF spdf = this.pfFactory.createSamplePDFFromDouble(0.1, samples, false, this.getTestUnit());
        Assert.assertTrue((!spdf.isInFrequencyDomain() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)spdf.getUnit().getUnitName().equals("sec"));
    }

    @Test
    public void createPMFFromMeasurements() {
        Double[] measurements = new Double[]{0.123, 0.34, 0.124, 0.343, 1.934, 0.345, 1.935, 1.94, 1.945, 2.134};
        IProbabilityMassFunction pmf = this.pfFactory.createPMFFromMeasurements(measurements, 0.01, this.getTestUnit(), true);
        Assert.assertEquals((long)5L, (long)pmf.getSamples().size());
        Assert.assertTrue((0.2 == ((ISample)pmf.getSamples().get(0)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.3 == ((ISample)pmf.getSamples().get(1)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.3 == ((ISample)pmf.getSamples().get(2)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.1 == ((ISample)pmf.getSamples().get(3)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.1 == ((ISample)pmf.getSamples().get(4)).getProbability() ? 1 : 0) != 0);
        Integer[] m2 = new Integer[]{2, 7, 7, 3, 2, 3, 3, 1, 3, 0};
        pmf = this.pfFactory.createPMFFromMeasurements(m2, this.getTestUnit(), true);
        Assert.assertEquals((long)5L, (long)pmf.getSamples().size());
        Assert.assertTrue((0.1 == ((ISample)pmf.getSamples().get(0)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.1 == ((ISample)pmf.getSamples().get(1)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.2 == ((ISample)pmf.getSamples().get(2)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.4 == ((ISample)pmf.getSamples().get(3)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.2 == ((ISample)pmf.getSamples().get(4)).getProbability() ? 1 : 0) != 0);
        String[] m3 = new String[]{"test1", "test2", "1test", "test1", "1test", "test3", "test3", "test1", "test2", "test2"};
        pmf = this.pfFactory.createPMFFromMeasurements(m3, this.getTestUnit(), true);
        Assert.assertEquals((long)4L, (long)pmf.getSamples().size());
        Assert.assertTrue((0.2 == ((ISample)pmf.getSamples().get(0)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.3 == ((ISample)pmf.getSamples().get(1)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.3 == ((ISample)pmf.getSamples().get(2)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.2 == ((ISample)pmf.getSamples().get(3)).getProbability() ? 1 : 0) != 0);
        Boolean[] m4 = new Boolean[]{true, true, false, true, false, true, false, false, false, false};
        pmf = this.pfFactory.createPMFFromMeasurements(m4, this.getTestUnit(), true);
        Assert.assertEquals((long)2L, (long)pmf.getSamples().size());
        Assert.assertTrue((0.6 == ((ISample)pmf.getSamples().get(0)).getProbability() ? 1 : 0) != 0);
        Assert.assertTrue((0.4 == ((ISample)pmf.getSamples().get(1)).getProbability() ? 1 : 0) != 0);
    }

    @Test
    public void transformContinuousToBoxedPDF() throws UnknownPDFTypeException, ProbabilitySumNotOneException, DoubleSampleException, FunctionNotInTimeDomainException, NegativeDistanceException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        LognormalDistribution lognorm = new LognormalDistribution(1.0, 0.5);
        ExponentialDistribution exp = new ExponentialDistribution(0.5);
        GammaDistribution gamma = new GammaDistribution(3.0, 2.0);
        this.transformAndCheck((IProbabilityDensityFunction)lognorm);
        this.transformAndCheck((IProbabilityDensityFunction)exp);
        this.transformAndCheck((IProbabilityDensityFunction)gamma);
    }

    private void transformAndCheck(IProbabilityDensityFunction func) throws UnknownPDFTypeException, ProbabilitySumNotOneException, DoubleSampleException, FunctionNotInTimeDomainException, NegativeDistanceException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        IProbabilityFunctionFactory factory = ProbabilityFunctionFactoryImpl.getInstance();
        IBoxedPDF boxedPDF = factory.transformToBoxedPDF(func);
        boxedPDF.checkConstrains();
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ProbabilityFunctionFactoryTest.class);
    }

    private List<ISample> getTestSamples() {
        Object[] testSamples = new Object[]{1, 0.1, 2, 0.3, 3, 0.5, 4, 0.1};
        ArrayList<ISample> sList = new ArrayList<ISample>();
        int i = 0;
        while (i < testSamples.length) {
            ISample s = this.pfFactory.createSample(testSamples[i], ((Double)testSamples[i + 1]).doubleValue());
            sList.add(s);
            i += 2;
        }
        return sList;
    }

    private List<IContinuousSample> getTestContinuousSamples() {
        Double[] testSamples = new Double[]{1.0, 0.1, 2.0, 0.3, 3.0, 0.5, 4.0, 0.1};
        ArrayList<IContinuousSample> sList = new ArrayList<IContinuousSample>();
        int i = 0;
        while (i < testSamples.length) {
            IContinuousSample s = this.pfFactory.createContinuousSample(testSamples[i].doubleValue(), testSamples[i + 1].doubleValue());
            sList.add(s);
            i += 2;
        }
        return sList;
    }

    private void initTestESamples(EList esList) {
        Object[] testSamples = new Object[]{2, 0.1, 4, 0.3, 6, 0.5, 8, 0.1};
        int i = 0;
        while (i < testSamples.length) {
            Sample s = this.epfFactory.createSample();
            s.setValue(testSamples[i]);
            s.setProbability(((Double)testSamples[i + 1]).doubleValue());
            esList.add((Object)s);
            i += 2;
        }
    }

    private void initTestEContinuousSamples(EList esList) {
        Double[] testSamples = new Double[]{2.1, 0.1, 3.5, 0.3, 6.2, 0.5, 6.7, 0.1};
        int i = 0;
        while (i < testSamples.length) {
            ContinuousSample s = this.epfFactory.createContinuousSample();
            s.setValue(testSamples[i].doubleValue());
            s.setProbability(testSamples[i + 1].doubleValue());
            esList.add((Object)s);
            i += 2;
        }
    }

    private IUnit getTestUnit() {
        return this.pfFactory.createUnit("sec");
    }
}

