/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.test;

import de.uka.ipd.sdq.probfunction.math.IBoxedPDF;
import de.uka.ipd.sdq.probfunction.math.IContinuousSample;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.DoubleSampleException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BoxedPDFTest {
    private IBoxedPDF df1;
    private IBoxedPDF df2;
    private IProbabilityFunctionFactory dfFactory = IProbabilityFunctionFactory.eINSTANCE;

    private IBoxedPDF createBoxedPDF(Double[] samples) throws DoubleSampleException {
        ArrayList<IContinuousSample> sList = new ArrayList<IContinuousSample>();
        int i = 0;
        while (i < samples.length) {
            IContinuousSample s = this.dfFactory.createContinuousSample(samples[i].doubleValue(), samples[i + 1].doubleValue());
            sList.add(s);
            i += 2;
        }
        return this.dfFactory.createBoxedPDF(sList, this.dfFactory.createDefaultUnit());
    }

    @Before
    public void setUp() throws DoubleSampleException {
        this.df1 = this.createBoxedPDF(new Double[]{3.0, 0.1, 2.1, 0.2, 4.3, 0.4, 1.5, 0.3});
        this.df2 = this.createBoxedPDF(new Double[]{3.0, 0.0, 2.1, 0.2, 2.2, 0.1, 2.5, 0.2, 4.3, 0.3});
    }

    @Test
    public void arithmeticMean() throws DomainNotNumbersException, FunctionNotInTimeDomainException {
        double meanDf1 = 2.3;
        System.out.println(this.df1);
        Assert.assertEquals((Object)meanDf1, (Object)this.df1.getArithmeticMeanValue());
    }

    @Test
    public void timeDomain() throws FunctionNotInTimeDomainException {
        Assert.assertTrue((boolean)this.df1.isInTimeDomain());
        Assert.assertTrue((boolean)this.df2.isInTimeDomain());
        Assert.assertFalse((boolean)this.df1.isInFrequencyDomain());
        IProbabilityDensityFunction pdf = this.df1.getFourierTransform();
        Assert.assertFalse((boolean)pdf.isInTimeDomain());
        Assert.assertTrue((boolean)pdf.isInFrequencyDomain());
    }

    @Test
    public void equals() throws DoubleSampleException {
        Assert.assertTrue((boolean)this.df1.equals(this.df1));
        IBoxedPDF df1copy = this.createBoxedPDF(new Double[]{3.0, 0.1, 2.1, 0.2, 4.3, 0.4, 1.5, 0.3});
        Assert.assertTrue((boolean)this.df1.equals(df1copy));
        Assert.assertFalse((boolean)this.df2.equals(this.df1));
        IBoxedPDF df1WrongCopy = this.createBoxedPDF(new Double[]{2.1, 0.2, 3.0, 0.1, 4.3, 0.4, 1.5, 0.3});
        Assert.assertTrue((boolean)this.df1.equals(df1WrongCopy));
    }

    @Test
    public void scale() throws DoubleSampleException {
        IProbabilityDensityFunction df1scale = this.df1.scale(0.1);
        IBoxedPDF spdf = this.createBoxedPDF(new Double[]{3.0, 0.01, 2.1, 0.02, 4.3, 0.04, 1.5, 0.03});
        Assert.assertEquals((Object)spdf, (Object)df1scale);
    }

    @Test
    public void add() throws DoubleSampleException, FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        IProbabilityDensityFunction sum = this.df1.add((IProbabilityDensityFunction)this.df1);
        IBoxedPDF sumExpected = this.createBoxedPDF(new Double[]{3.0, 0.2, 2.1, 0.4, 4.3, 0.8, 1.5, 0.6});
        Assert.assertEquals((Object)this.dfFactory.transformToSamplePDF((IProbabilityDensityFunction)sumExpected), (Object)((ISamplePDF)sum));
    }

    @Test
    @Ignore
    public void mult() throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException, DoubleSampleException {
        ISamplePDF df11 = this.dfFactory.transformToSamplePDF((IProbabilityDensityFunction)this.df1);
        IProbabilityDensityFunction prod = df11.mult((IProbabilityDensityFunction)df11);
        System.out.println(prod);
        IBoxedPDF expected = this.createBoxedPDF(new Double[]{3.0, 0.01, 2.1, 0.04, 4.3, 0.16, 1.5, 0.09});
        ISamplePDF sExpexted = this.dfFactory.transformToSamplePDF((IProbabilityDensityFunction)expected);
        System.out.println(sExpexted);
        Assert.assertEquals((Object)sExpexted, (Object)((ISamplePDF)prod));
    }

    @Test
    public void percentile() throws IndexOutOfBoundsException, UnorderedDomainException {
        Assert.assertEquals((Object)0.3, (Object)this.df1.getPercentile(10));
        Assert.assertEquals((Object)0.2, (Object)this.df1.getPercentile(40));
        Assert.assertEquals((Object)0.1, (Object)this.df1.getPercentile(50));
        Assert.assertEquals((Object)0.4, (Object)this.df1.getPercentile(99));
    }

    @Test
    public void getMedian() throws UnorderedDomainException, DoubleSampleException {
        Assert.assertEquals((Object)2.55, (Object)this.df1.getMedian());
        IBoxedPDF df = this.createBoxedPDF(new Double[]{3.0, 0.1, 2.1, 0.2, 4.3, 0.4, 1.5, 0.1, 1.4, 0.2});
        Assert.assertEquals((Object)2.1, (Object)df.getMedian());
    }

    @Test
    public void checkConstraints() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        this.df1.checkConstrains();
    }

    @Test(expected=InvalidSampleValueException.class)
    public void checkConstraints1() throws DoubleSampleException, NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        IBoxedPDF b = this.createBoxedPDF(new Double[]{3.0, 0.1, 2.1, 0.4, 4.3, 0.3, -1.5, 0.2});
        b.checkConstrains();
    }

    @Test(expected=ProbabilitySumNotOneException.class)
    public void checkConstraints2() throws DoubleSampleException, NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        IBoxedPDF b = this.createBoxedPDF(new Double[]{3.0, 0.1, 2.1, 0.4, 4.3, 0.3, 1.5, 0.3});
        b.checkConstrains();
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(BoxedPDFTest.class);
    }
}

