/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.probes;

import de.uka.ipd.sdq.probespec.framework.ProbeType;
import de.uka.ipd.sdq.probespec.framework.exceptions.ProbeStrategyNotFoundException;
import de.uka.ipd.sdq.probespec.framework.probes.IProbeStrategy;
import de.uka.ipd.sdq.probespec.framework.probes.IProbeStrategyRegistry;
import java.util.HashMap;
import java.util.Map;

public class ProbeStrategyRegistry
implements IProbeStrategyRegistry {
    private Map<ProbeTypeEntityPair, IProbeStrategy> strategiesMap = new HashMap<ProbeTypeEntityPair, IProbeStrategy>();

    @Override
    public IProbeStrategy getProbeStrategy(ProbeType type, Object measurableEntity) {
        ProbeTypeEntityPair pair = new ProbeTypeEntityPair(type, measurableEntity);
        IProbeStrategy strategy = this.strategiesMap.get(pair);
        if (strategy == null) {
            throw new ProbeStrategyNotFoundException("Could not find a ProbeStrategy for probe type " + type.name() + " that is able to measure a " + measurableEntity.getClass().getSimpleName());
        }
        return strategy;
    }

    @Override
    public void registerProbeStrategy(IProbeStrategy strategy, ProbeType type, Object measurableEntity) {
        ProbeTypeEntityPair pair = new ProbeTypeEntityPair(type, measurableEntity);
        this.strategiesMap.put(pair, strategy);
    }

    private class ProbeTypeEntityPair {
        private ProbeType type;
        private Object entity;

        public ProbeTypeEntityPair(ProbeType type, Object entity) {
            this.type = type;
            this.entity = entity;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ProbeTypeEntityPair)) {
                return false;
            }
            ProbeTypeEntityPair other = (ProbeTypeEntityPair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }

        private ProbeStrategyRegistry getOuterType() {
            return ProbeStrategyRegistry.this;
        }
    }
}

