/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.garbagecollection;

import de.uka.ipd.sdq.probespec.framework.ProbeSetAndRequestContext;
import de.uka.ipd.sdq.probespec.framework.garbagecollection.IRegionBasedGarbageCollector;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class RegionBasedGarbageCollector<T>
implements IRegionBasedGarbageCollector<T> {
    public static Logger logger = Logger.getLogger(RegionBasedGarbageCollector.class);
    private Map<T, Integer> regionCountMap = new HashMap<T, Integer>();

    public abstract T obtainRegionId(ProbeSetAndRequestContext var1);

    @Override
    public void enterRegion(T regionId) {
        if (this.increasePopulation(regionId) == 1) {
            logger.debug((Object)("Region " + regionId + " opened."));
        }
    }

    @Override
    public void leaveRegion(T regionId) {
        if (this.decreasePopulation(regionId) == 0) {
            this.collectRegionSamples(regionId);
            logger.debug((Object)("Region " + regionId + " closed."));
        }
    }

    public abstract void collectRegionSamples(T var1);

    private int changePopulationCounter(T regionId, int amount) {
        int counter = 0;
        if (this.regionCountMap.containsKey(regionId)) {
            counter = this.regionCountMap.get(regionId);
        }
        this.regionCountMap.put(regionId, counter += amount);
        return counter;
    }

    private int increasePopulation(T regionId) {
        return this.changePopulationCounter(regionId, 1);
    }

    private int decreasePopulation(T regionId) {
        return this.changePopulationCounter(regionId, -1);
    }
}

