/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.concurrency;

import de.uka.ipd.sdq.probespec.framework.concurrency.StoppableRunnable;
import java.util.ArrayList;

public class ThreadManager {
    private ArrayList<RunnableThreadPair> runnableThreadList = new ArrayList();

    public void startThread(StoppableRunnable runnable, String threadName) {
        Thread thread = new Thread(runnable);
        this.runnableThreadList.add(new RunnableThreadPair(runnable, thread));
        thread.setName(threadName);
        thread.start();
    }

    public void stopThreads() {
        for (RunnableThreadPair p : this.runnableThreadList) {
            p.getRunnable().stop();
        }
        for (RunnableThreadPair p : this.runnableThreadList) {
            try {
                p.getThread().join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class RunnableThreadPair {
        private StoppableRunnable runnable;
        private Thread thread;

        public RunnableThreadPair(StoppableRunnable runnable, Thread thread) {
            this.runnable = runnable;
            this.thread = thread;
        }

        public StoppableRunnable getRunnable() {
            return this.runnable;
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

