/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.concurrency;

import de.uka.ipd.sdq.probespec.framework.ProbeSetAndRequestContext;
import de.uka.ipd.sdq.probespec.framework.ProbeSetSample;
import de.uka.ipd.sdq.probespec.framework.ProbeSpecContext;
import de.uka.ipd.sdq.probespec.framework.RequestContext;
import de.uka.ipd.sdq.probespec.framework.SampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.concurrency.StoppableRunnable;
import java.util.concurrent.LinkedBlockingQueue;

public class ConcurrentSampleBlackboard
extends SampleBlackboard {
    private LinkedBlockingQueue<QueuedAction> sampleQueue = new LinkedBlockingQueue();

    public ConcurrentSampleBlackboard() {
        ProbeSpecContext.instance().getThreadManager().startThread(new ProcessQueuedActions(), "ProbeSpec Concurrent Blackboard");
    }

    private void delegateAddSample(ProbeSetSample pss) {
        super.addSample(pss);
    }

    private void delegateDeleteSamplesInRequestContext(RequestContext requestContext) {
        super.deleteSamplesInRequestContext(requestContext);
    }

    private void delegateDeleteSample(ProbeSetAndRequestContext pss) {
        this.deleteSample(pss);
    }

    @Override
    public void addSample(ProbeSetSample pss) {
        try {
            this.sampleQueue.put(new AddSampleAction(pss));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteSamplesInRequestContext(RequestContext requestContext) {
        try {
            this.sampleQueue.put(new DeleteSamplesInRequestContextAction(requestContext));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteSample(ProbeSetAndRequestContext pss) {
        try {
            this.sampleQueue.put(new DeleteSampleAction(pss));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class AddSampleAction
    implements QueuedAction {
        private ProbeSetSample pss;

        public AddSampleAction(ProbeSetSample pss) {
            this.pss = pss;
        }

        @Override
        public void execute() {
            ConcurrentSampleBlackboard.this.delegateAddSample(this.pss);
        }
    }

    private class DeleteSampleAction
    implements QueuedAction {
        private ProbeSetAndRequestContext pss;

        public DeleteSampleAction(ProbeSetAndRequestContext pss) {
            this.pss = pss;
        }

        @Override
        public void execute() {
            ConcurrentSampleBlackboard.this.delegateDeleteSample(this.pss);
        }
    }

    private class DeleteSamplesInRequestContextAction
    implements QueuedAction {
        private RequestContext requestContext;

        public DeleteSamplesInRequestContextAction(RequestContext requestContext) {
            this.requestContext = requestContext;
        }

        @Override
        public void execute() {
            ConcurrentSampleBlackboard.this.delegateDeleteSamplesInRequestContext(this.requestContext);
        }
    }

    private class ProcessQueuedActions
    implements StoppableRunnable {
        private boolean keepRunning = true;

        private ProcessQueuedActions() {
        }

        @Override
        public void run() {
            while (this.keepRunning || !ConcurrentSampleBlackboard.this.sampleQueue.isEmpty()) {
                try {
                    ((QueuedAction)ConcurrentSampleBlackboard.this.sampleQueue.take()).execute();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Runnable " + this.getClass().getSimpleName() + " stopped running!");
        }

        @Override
        public void stop() {
            this.keepRunning = false;
            if (ConcurrentSampleBlackboard.this.sampleQueue.isEmpty()) {
                try {
                    ConcurrentSampleBlackboard.this.sampleQueue.put(new ShutdownQueueAction());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static interface QueuedAction {
        public void execute();
    }

    private class ShutdownQueueAction
    implements QueuedAction {
        private ShutdownQueueAction() {
        }

        @Override
        public void execute() {
        }
    }
}

