/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.calculator;

import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.ProbeSample;
import de.uka.ipd.sdq.probespec.framework.ProbeSetSample;
import de.uka.ipd.sdq.probespec.framework.ProbeType;
import de.uka.ipd.sdq.probespec.framework.calculator.BinaryCalculator;
import de.uka.ipd.sdq.probespec.framework.exceptions.CalculatorException;
import de.uka.ipd.sdq.probespec.framework.matching.IMatchRule;
import de.uka.ipd.sdq.probespec.framework.matching.ProbeTypeMatchRule;
import java.util.Vector;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

public abstract class TimeSpanCalculator
extends BinaryCalculator {
    public TimeSpanCalculator(ISampleBlackboard blackboard, Integer startProbeSetID, Integer endProbeSetID) {
        super(blackboard, startProbeSetID, endProbeSetID);
    }

    @Override
    protected Vector<Measure<?, ? extends Quantity>> calculate(ProbeSetSample start, ProbeSetSample end) throws CalculatorException {
        ProbeSample<Double, Duration> startTimeSample = this.obtainCurrentTimeProbeSample(start);
        if (startTimeSample == null) {
            throw new CalculatorException("Could not access start probe sample.");
        }
        ProbeSample<Double, Duration> endTimeSample = this.obtainCurrentTimeProbeSample(end);
        if (endTimeSample == null) {
            throw new CalculatorException("Could not access end probe sample.");
        }
        double endTime = endTimeSample.getMeasure().doubleValue(startTimeSample.getMeasure().getUnit());
        double startTime = startTimeSample.getMeasure().doubleValue(startTimeSample.getMeasure().getUnit());
        double responseTime = endTime - startTime;
        Measure timeSpanMeasure = Measure.valueOf((double)responseTime, (Unit)startTimeSample.getMeasure().getUnit());
        Measure<Double, Duration> endTimeMeasure = endTimeSample.getMeasure();
        Vector resultTuple = new Vector();
        resultTuple.add(timeSpanMeasure);
        resultTuple.add(endTimeMeasure);
        return resultTuple;
    }

    private ProbeSample<Double, Duration> obtainCurrentTimeProbeSample(ProbeSetSample probeSetSample) {
        IMatchRule[] rules = new IMatchRule[]{new ProbeTypeMatchRule(ProbeType.CURRENT_TIME)};
        Vector<ProbeSample<?, Quantity>> result = probeSetSample.getProbeSamples(rules);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }
}

