/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.calculator;

import de.uka.ipd.sdq.pipesandfilters.framework.CaptureType;
import de.uka.ipd.sdq.pipesandfilters.framework.MeasurementMetric;
import de.uka.ipd.sdq.pipesandfilters.framework.Scale;
import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.ProbeSample;
import de.uka.ipd.sdq.probespec.framework.ProbeSetSample;
import de.uka.ipd.sdq.probespec.framework.ProbeType;
import de.uka.ipd.sdq.probespec.framework.calculator.UnaryCalculator;
import de.uka.ipd.sdq.probespec.framework.exceptions.CalculatorException;
import de.uka.ipd.sdq.probespec.framework.matching.IMatchRule;
import de.uka.ipd.sdq.probespec.framework.matching.ProbeTypeMatchRule;
import java.util.Vector;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

public class StateCalculator
extends UnaryCalculator {
    private static Vector<MeasurementMetric> concreteMeasurementMetrics;

    public StateCalculator(ISampleBlackboard blackboard, Integer probeSetID) {
        super(blackboard, probeSetID);
    }

    @Override
    protected Vector<Measure<?, ? extends Quantity>> calculate(ProbeSetSample sample) throws CalculatorException {
        IMatchRule[] rules = new IMatchRule[]{new ProbeTypeMatchRule(ProbeType.CURRENT_TIME)};
        Vector<ProbeSample<?, Quantity>> result = sample.getProbeSamples(rules);
        ProbeSample<?, Quantity> time = null;
        if (result != null && result.size() > 0) {
            time = result.get(0);
        }
        rules[0] = new ProbeTypeMatchRule(ProbeType.RESOURCE_STATE);
        result = sample.getProbeSamples(rules);
        ProbeSample<?, Quantity> resourceState = null;
        if (result != null && result.size() > 0) {
            resourceState = result.get(0);
        }
        if (time != null && resourceState != null) {
            Vector resultTuple = new Vector();
            resultTuple.add(time.getMeasure());
            resultTuple.add(resourceState.getMeasure());
            return resultTuple;
        }
        throw new CalculatorException("Could not access all needed probe samples.");
    }

    @Override
    protected synchronized Vector<MeasurementMetric> getConcreteMeasurementMetrics() {
        if (concreteMeasurementMetrics == null) {
            concreteMeasurementMetrics = new Vector();
            MeasurementMetric mm = new MeasurementMetric(CaptureType.NATURAL_NUMBER, SI.MILLI((Unit)SI.SECOND), Scale.ORDINAL);
            mm.setDescription("This meausre represents the point of time when the value is taken");
            mm.setMonotonic(false);
            mm.setName("Point of time");
            mm.setStrongMonotonic(false);
            concreteMeasurementMetrics.add(mm);
            mm = new MeasurementMetric(CaptureType.NATURAL_NUMBER, Dimensionless.UNIT, Scale.ORDINAL);
            mm.setDescription("This measure represents the state of the CPU resource");
            mm.setMonotonic(false);
            mm.setName("State of the CPU resource");
            mm.setStrongMonotonic(false);
            concreteMeasurementMetrics.add(mm);
        }
        return concreteMeasurementMetrics;
    }
}

