/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.calculator;

import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.ProbeSample;
import de.uka.ipd.sdq.probespec.framework.ProbeSetSample;
import de.uka.ipd.sdq.probespec.framework.ProbeType;
import de.uka.ipd.sdq.probespec.framework.calculator.WaitingTimeCalculator;
import de.uka.ipd.sdq.probespec.framework.exceptions.CalculatorException;
import de.uka.ipd.sdq.probespec.framework.matching.IMatchRule;
import de.uka.ipd.sdq.probespec.framework.matching.ProbeTypeMatchRule;
import java.util.Vector;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

public class DemandBasedWaitingTimeCalculator
extends WaitingTimeCalculator {
    public DemandBasedWaitingTimeCalculator(ISampleBlackboard blackboard, Integer startWaitingProbeSetID, Integer stopProcessingProbeSetID) {
        super(blackboard, startWaitingProbeSetID, stopProcessingProbeSetID);
    }

    @Override
    protected Vector<Measure<?, ? extends Quantity>> calculate(ProbeSetSample start, ProbeSetSample end) throws CalculatorException {
        ProbeSample<Double, Duration> demandSample = this.obtainDemandProbeSample(start);
        if (demandSample == null) {
            throw new CalculatorException("Could not access demand probe sample.");
        }
        Vector<Measure<?, Quantity>> timeSpanResultTuple = super.calculate(start, end);
        Measure<?, ? extends Quantity> processingTimeSpanMeasure = timeSpanResultTuple.get(0);
        Measure<?, ? extends Quantity> endTimeMeasure = timeSpanResultTuple.get(1);
        Unit unit = processingTimeSpanMeasure.getUnit();
        double demand = demandSample.getMeasure().doubleValue(unit);
        double processingTime = processingTimeSpanMeasure.doubleValue(unit);
        double waitingTime = processingTime - demand;
        if (waitingTime < 0.0) {
            waitingTime = 0.0;
        }
        Measure waitingTimeMeasure = Measure.valueOf((double)waitingTime, (Unit)unit);
        Vector resultTuple = new Vector();
        resultTuple.add(waitingTimeMeasure);
        resultTuple.add(endTimeMeasure);
        return resultTuple;
    }

    private ProbeSample<Double, Duration> obtainDemandProbeSample(ProbeSetSample probeSetSample) {
        IMatchRule[] rules = new IMatchRule[]{new ProbeTypeMatchRule(ProbeType.RESOURCE_DEMAND)};
        Vector<ProbeSample<?, Quantity>> result = probeSetSample.getProbeSamples(rules);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }
}

