/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.calculator;

import de.uka.ipd.sdq.pipesandfilters.framework.MeasurementMetric;
import de.uka.ipd.sdq.probespec.framework.BlackboardVote;
import de.uka.ipd.sdq.probespec.framework.IBlackboardListener;
import de.uka.ipd.sdq.probespec.framework.ProbeSetSample;
import de.uka.ipd.sdq.probespec.framework.calculator.ICalculatorListener;
import de.uka.ipd.sdq.probespec.framework.exceptions.CalculatorException;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;

public abstract class Calculator
implements IBlackboardListener {
    private Vector<MeasurementMetric> measurementMetrics = this.getConcreteMeasurementMetrics();
    private CopyOnWriteArrayList<ICalculatorListener> listeners = new CopyOnWriteArrayList();

    protected Calculator() {
    }

    public Vector<MeasurementMetric> getMeasurementMetrics() {
        return this.measurementMetrics;
    }

    @Override
    public BlackboardVote sampleArrived(ProbeSetSample pss) {
        try {
            return this.execute(pss);
        }
        catch (CalculatorException e) {
            e.printStackTrace();
            return BlackboardVote.DISCARD;
        }
    }

    protected abstract BlackboardVote execute(ProbeSetSample var1) throws CalculatorException;

    protected abstract Vector<MeasurementMetric> getConcreteMeasurementMetrics();

    public void addCalculatorListener(ICalculatorListener l) {
        this.listeners.add(l);
    }

    protected void fireCalculated(Vector<Measure<?, ? extends Quantity>> resultTuple) {
        for (ICalculatorListener l : this.listeners) {
            l.calculated(resultTuple);
        }
    }
}

