/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.calculator;

import de.uka.ipd.sdq.pipesandfilters.framework.MeasurementMetric;
import de.uka.ipd.sdq.probespec.framework.BlackboardVote;
import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.ProbeSetAndRequestContext;
import de.uka.ipd.sdq.probespec.framework.ProbeSetSample;
import de.uka.ipd.sdq.probespec.framework.calculator.Calculator;
import de.uka.ipd.sdq.probespec.framework.exceptions.CalculatorException;
import de.uka.ipd.sdq.probespec.framework.utils.ProbeSpecUtils;
import java.util.Vector;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;

public abstract class BinaryCalculator
extends Calculator {
    private ISampleBlackboard blackboard;
    private Integer startProbeSetID;
    private Integer endProbeSetID;

    public BinaryCalculator(ISampleBlackboard blackboard, Integer startProbeSetID, Integer endProbeSetID) {
        this.blackboard = blackboard;
        this.startProbeSetID = startProbeSetID;
        this.endProbeSetID = endProbeSetID;
        blackboard.addBlackboardListener(this, startProbeSetID, endProbeSetID);
    }

    protected abstract Vector<Measure<?, ? extends Quantity>> calculate(ProbeSetSample var1, ProbeSetSample var2) throws CalculatorException;

    @Override
    protected abstract Vector<MeasurementMetric> getConcreteMeasurementMetrics();

    @Override
    protected BlackboardVote execute(ProbeSetSample pss) throws CalculatorException {
        if (this.endProbeSetID.equals(pss.getProbeSetAndRequestContext().getProbeSetID())) {
            ProbeSetSample endSetSample = pss;
            ProbeSetSample startSetSample = this.blackboard.getSample(new ProbeSetAndRequestContext(this.startProbeSetID, pss.getProbeSetAndRequestContext().getCtxID()));
            if (startSetSample == null) {
                throw new CalculatorException("Could not find sample for ProbeSetID " + ProbeSpecUtils.ProbeSetIdToString(this.startProbeSetID) + " within context " + pss.getProbeSetAndRequestContext().getCtxID());
            }
            Vector<Measure<?, ? extends Quantity>> resultTuple = this.calculate(startSetSample, endSetSample);
            this.fireCalculated(resultTuple);
            return BlackboardVote.DISCARD;
        }
        if (this.startProbeSetID.equals(pss.getProbeSetAndRequestContext().getProbeSetID())) {
            return BlackboardVote.RETAIN;
        }
        return BlackboardVote.DISCARD;
    }
}

