/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework;

import de.uka.ipd.sdq.probespec.framework.BlackboardVote;
import de.uka.ipd.sdq.probespec.framework.IBlackboardListener;
import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.ProbeSetAndRequestContext;
import de.uka.ipd.sdq.probespec.framework.ProbeSetSample;
import de.uka.ipd.sdq.probespec.framework.RequestContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleBlackboard
implements ISampleBlackboard {
    private List<IBlackboardListener> listeners;
    private HashMap<Integer, ArrayList<IBlackboardListener>> topicToListenersMap;
    private HashMap<RequestContext, HashMap<ProbeSetAndRequestContext, ProbeSetSample>> sampleMap = new HashMap();

    public SampleBlackboard() {
        this.listeners = new ArrayList<IBlackboardListener>();
        this.topicToListenersMap = new HashMap();
    }

    @Override
    public void addSample(ProbeSetSample pss) {
        BlackboardVote deletionVote = this.fireSampleArrived(pss);
        if (deletionVote.equals((Object)BlackboardVote.RETAIN)) {
            RequestContext context = pss.getProbeSetAndRequestContext().getCtxID();
            HashMap<ProbeSetAndRequestContext, ProbeSetSample> contextMap = this.sampleMap.get(context);
            if (contextMap == null) {
                contextMap = new HashMap();
                this.sampleMap.put(context, contextMap);
            }
            contextMap.put(pss.getProbeSetAndRequestContext(), pss);
        }
    }

    @Override
    public void deleteSample(ProbeSetAndRequestContext pss) {
        this.sampleMap.get(pss.getCtxID()).remove(pss);
    }

    @Override
    public void deleteSamplesInRequestContext(RequestContext requestContext) {
        HashMap<ProbeSetAndRequestContext, ProbeSetSample> contextMap = this.sampleMap.get(requestContext);
        if (contextMap != null) {
            contextMap.clear();
            this.sampleMap.remove(requestContext);
        }
    }

    @Override
    public ProbeSetSample getSample(ProbeSetAndRequestContext probeSetSampleID) {
        ProbeSetSample sample = this.obtainSample(probeSetSampleID);
        if (sample != null) {
            return sample;
        }
        RequestContext ctx = probeSetSampleID.getCtxID().getParentContext();
        Integer probeSetID = probeSetSampleID.getProbeSetID();
        while (ctx != null) {
            ProbeSetAndRequestContext pssID = new ProbeSetAndRequestContext(probeSetID, ctx);
            ProbeSetSample pss = this.obtainSample(pssID);
            if (pss != null) {
                return pss;
            }
            ctx = ctx.getParentContext();
        }
        return null;
    }

    private ProbeSetSample obtainSample(ProbeSetAndRequestContext probeSetSampleID) {
        HashMap<ProbeSetAndRequestContext, ProbeSetSample> contextMap = this.sampleMap.get(probeSetSampleID.getCtxID());
        if (contextMap != null) {
            return contextMap.get(probeSetSampleID);
        }
        return null;
    }

    @Override
    public int size() {
        int i = 0;
        for (Map.Entry<RequestContext, HashMap<ProbeSetAndRequestContext, ProbeSetSample>> e : this.sampleMap.entrySet()) {
            i += e.getValue().size();
        }
        return i;
    }

    @Override
    public void addBlackboardListener(IBlackboardListener l, Integer ... topics) {
        if (topics.length == 0) {
            this.listeners.add(l);
        } else {
            Integer[] integerArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                Integer t = integerArray[n2];
                ArrayList<IBlackboardListener> listeners = this.topicToListenersMap.get(t);
                if (listeners == null) {
                    listeners = new ArrayList();
                    this.topicToListenersMap.put(t, listeners);
                }
                listeners.add(l);
                ++n2;
            }
        }
    }

    private BlackboardVote fireSampleArrived(ProbeSetSample pss, List<IBlackboardListener> listeners) {
        BlackboardVote deletionVote = BlackboardVote.DISCARD;
        for (IBlackboardListener l : listeners) {
            if (!l.sampleArrived(pss).equals((Object)BlackboardVote.RETAIN)) continue;
            deletionVote = BlackboardVote.RETAIN;
        }
        return deletionVote;
    }

    private BlackboardVote fireSampleArrived(ProbeSetSample pss) {
        BlackboardVote firstDeletionVote = this.fireSampleArrived(pss, this.listeners);
        Integer topic = pss.getProbeSetAndRequestContext().getProbeSetID();
        List listeners = this.topicToListenersMap.get(topic);
        BlackboardVote secondDeletionVote = null;
        if (listeners != null) {
            secondDeletionVote = this.fireSampleArrived(pss, listeners);
        }
        if (firstDeletionVote.equals((Object)BlackboardVote.DISCARD) && (secondDeletionVote == null || secondDeletionVote.equals((Object)BlackboardVote.DISCARD))) {
            return BlackboardVote.DISCARD;
        }
        return BlackboardVote.RETAIN;
    }
}

