/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework;

import de.uka.ipd.sdq.pipesandfilters.framework.PipesAndFiltersManager;
import de.uka.ipd.sdq.probespec.framework.ISampleBlackboard;
import de.uka.ipd.sdq.probespec.framework.Registry;
import de.uka.ipd.sdq.probespec.framework.RequestContext;
import de.uka.ipd.sdq.probespec.framework.calculator.CalculatorRegistry;
import de.uka.ipd.sdq.probespec.framework.calculator.ICalculatorFactory;
import de.uka.ipd.sdq.probespec.framework.concurrency.ThreadManager;
import de.uka.ipd.sdq.probespec.framework.garbagecollection.IRegionBasedGarbageCollector;
import de.uka.ipd.sdq.probespec.framework.probes.IProbeStrategyRegistry;
import de.uka.ipd.sdq.probespec.framework.utils.ProbeSetIDGenerator;

public class ProbeSpecContext {
    private static ProbeSpecContext instance = new ProbeSpecContext();
    private IProbeStrategyRegistry probeStrategyRegistry;
    private ICalculatorFactory calculatorFactory;
    private ISampleBlackboard sampleBlackboard;
    private ThreadManager threadManager;
    private ProbeSetIDGenerator probeSetIdGenerator;
    private IRegionBasedGarbageCollector<RequestContext> blackboardGarbageCollector;
    private CalculatorRegistry calculatorRegistry;
    private Registry<PipesAndFiltersManager> pipeManagerRegisty;

    private ProbeSpecContext() {
        this.initialise(null, null, null, null);
    }

    public void initialise(ISampleBlackboard sampleBlackboard, IRegionBasedGarbageCollector<RequestContext> blackboardGarbageCollector, IProbeStrategyRegistry probeStrategyRegistry, ICalculatorFactory calculatorFactory) {
        this.threadManager = new ThreadManager();
        this.probeSetIdGenerator = new ProbeSetIDGenerator();
        this.calculatorRegistry = new CalculatorRegistry();
        this.pipeManagerRegisty = new Registry();
        this.setSampleBlackboard(sampleBlackboard);
        this.setBlackboardGarbageCollector(blackboardGarbageCollector);
        this.setProbeStrategyRegistry(probeStrategyRegistry);
        this.setCalculatorFactory(calculatorFactory);
    }

    public static ProbeSpecContext instance() {
        return instance;
    }

    public Integer obtainProbeSetId(String probeSetId) {
        return this.probeSetIdGenerator.obtainId(probeSetId);
    }

    public String obtainOriginalProbeSetId(Integer probeSetId) {
        return this.probeSetIdGenerator.obtainOriginalId(probeSetId);
    }

    public IProbeStrategyRegistry getProbeStrategyRegistry() {
        return this.probeStrategyRegistry;
    }

    public void setProbeStrategyRegistry(IProbeStrategyRegistry probeStrategyRegistry) {
        this.probeStrategyRegistry = probeStrategyRegistry;
    }

    public ICalculatorFactory getCalculatorFactory() {
        return this.calculatorFactory;
    }

    public void setCalculatorFactory(ICalculatorFactory calculatorFactory) {
        this.calculatorFactory = calculatorFactory;
    }

    public ISampleBlackboard getSampleBlackboard() {
        return this.sampleBlackboard;
    }

    public void setSampleBlackboard(ISampleBlackboard sampleBlackboard) {
        this.sampleBlackboard = sampleBlackboard;
    }

    public IRegionBasedGarbageCollector<RequestContext> getBlackboardGarbageCollector() {
        return this.blackboardGarbageCollector;
    }

    public void setBlackboardGarbageCollector(IRegionBasedGarbageCollector<RequestContext> blackboardGarbageCollector) {
        this.blackboardGarbageCollector = blackboardGarbageCollector;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public CalculatorRegistry getCalculatorRegistry() {
        return this.calculatorRegistry;
    }

    public Registry<PipesAndFiltersManager> getPipeManagerRegisty() {
        return this.pipeManagerRegisty;
    }

    public void finish() {
        for (PipesAndFiltersManager p : this.pipeManagerRegisty) {
            p.flush();
        }
        this.getThreadManager().stopThreads();
    }
}

