/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probespec.framework.probes.example;

import de.uka.ipd.sdq.probespec.framework.ProbeSample;
import de.uka.ipd.sdq.probespec.framework.ProbeType;
import de.uka.ipd.sdq.probespec.framework.probes.IProbeStrategy;
import de.uka.ipd.sdq.probespec.framework.probes.example.ASimpleActiveResource;
import de.uka.ipd.sdq.probespec.framework.probes.example.ISimpleDemanding;
import de.uka.ipd.sdq.probespec.framework.probes.example.SimpleCPUResource;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;

public class ExampleTakeCPUDemandStrategy
implements IProbeStrategy {
    public ProbeSample<Double, Dimensionless> takeSample(String probeId, Object ... o) {
        ISimpleDemanding demanding = null;
        ASimpleActiveResource resource = null;
        Object[] objectArray = o;
        int n = o.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ISimpleDemanding) {
                demanding = (ISimpleDemanding)object;
            } else if (object instanceof SimpleCPUResource) {
                resource = (ASimpleActiveResource)object;
            }
            ++n2;
        }
        if (demanding == null) {
            throw new IllegalArgumentException("Expected an argument implementing IExampleDemanding.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Expected an argument of type SimpleCPUResource.");
        }
        Measure demand = Measure.valueOf((double)demanding.getDemand(resource), (Unit)Dimensionless.UNIT);
        ProbeSample sample = new ProbeSample(demand, probeId, ProbeType.RESOURCE_DEMAND);
        return sample;
    }
}

