/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.uka.ipd.sdq.probespec.provider;

import de.uka.ipd.sdq.probespec.util.probespecAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class probespecItemProviderAdapterFactory extends probespecAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public probespecItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.PassiveResourceCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PassiveResourceCalculatorItemProvider passiveResourceCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.PassiveResourceCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPassiveResourceCalculatorAdapter() {
		if (passiveResourceCalculatorItemProvider == null) {
			passiveResourceCalculatorItemProvider = new PassiveResourceCalculatorItemProvider(this);
		}

		return passiveResourceCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.ProbeSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbeSetItemProvider probeSetItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.ProbeSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProbeSetAdapter() {
		if (probeSetItemProvider == null) {
			probeSetItemProvider = new ProbeSetItemProvider(this);
		}

		return probeSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.PassiveResourceStateProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PassiveResourceStateProbeItemProvider passiveResourceStateProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.PassiveResourceStateProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPassiveResourceStateProbeAdapter() {
		if (passiveResourceStateProbeItemProvider == null) {
			passiveResourceStateProbeItemProvider = new PassiveResourceStateProbeItemProvider(this);
		}

		return passiveResourceStateProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.StoExProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StoExProbeItemProvider stoExProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.StoExProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStoExProbeAdapter() {
		if (stoExProbeItemProvider == null) {
			stoExProbeItemProvider = new StoExProbeItemProvider(this);
		}

		return stoExProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.SEFFParameterProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SEFFParameterProbeItemProvider seffParameterProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.SEFFParameterProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSEFFParameterProbeAdapter() {
		if (seffParameterProbeItemProvider == null) {
			seffParameterProbeItemProvider = new SEFFParameterProbeItemProvider(this);
		}

		return seffParameterProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.CurrentTimeProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CurrentTimeProbeItemProvider currentTimeProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.CurrentTimeProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCurrentTimeProbeAdapter() {
		if (currentTimeProbeItemProvider == null) {
			currentTimeProbeItemProvider = new CurrentTimeProbeItemProvider(this);
		}

		return currentTimeProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.StoExCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StoExCalculatorItemProvider stoExCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.StoExCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStoExCalculatorAdapter() {
		if (stoExCalculatorItemProvider == null) {
			stoExCalculatorItemProvider = new StoExCalculatorItemProvider(this);
		}

		return stoExCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.SEFFParameterCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SEFFParameterCalculatorItemProvider seffParameterCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.SEFFParameterCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSEFFParameterCalculatorAdapter() {
		if (seffParameterCalculatorItemProvider == null) {
			seffParameterCalculatorItemProvider = new SEFFParameterCalculatorItemProvider(this);
		}

		return seffParameterCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.ResponseTimeCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResponseTimeCalculatorItemProvider responseTimeCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.ResponseTimeCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResponseTimeCalculatorAdapter() {
		if (responseTimeCalculatorItemProvider == null) {
			responseTimeCalculatorItemProvider = new ResponseTimeCalculatorItemProvider(this);
		}

		return responseTimeCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.WaitingTimeCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WaitingTimeCalculatorItemProvider waitingTimeCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.WaitingTimeCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWaitingTimeCalculatorAdapter() {
		if (waitingTimeCalculatorItemProvider == null) {
			waitingTimeCalculatorItemProvider = new WaitingTimeCalculatorItemProvider(this);
		}

		return waitingTimeCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.ProbeSpecRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbeSpecRepositoryItemProvider probeSpecRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.ProbeSpecRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProbeSpecRepositoryAdapter() {
		if (probeSpecRepositoryItemProvider == null) {
			probeSpecRepositoryItemProvider = new ProbeSpecRepositoryItemProvider(this);
		}

		return probeSpecRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.CPUStateProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CPUStateProbeItemProvider cpuStateProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.CPUStateProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCPUStateProbeAdapter() {
		if (cpuStateProbeItemProvider == null) {
			cpuStateProbeItemProvider = new CPUStateProbeItemProvider(this);
		}

		return cpuStateProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.HDDStateProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HDDStateProbeItemProvider hddStateProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.HDDStateProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHDDStateProbeAdapter() {
		if (hddStateProbeItemProvider == null) {
			hddStateProbeItemProvider = new HDDStateProbeItemProvider(this);
		}

		return hddStateProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.CPUDemandProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CPUDemandProbeItemProvider cpuDemandProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.CPUDemandProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCPUDemandProbeAdapter() {
		if (cpuDemandProbeItemProvider == null) {
			cpuDemandProbeItemProvider = new CPUDemandProbeItemProvider(this);
		}

		return cpuDemandProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.HDDDemandProbe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HDDDemandProbeItemProvider hddDemandProbeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.HDDDemandProbe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHDDDemandProbeAdapter() {
		if (hddDemandProbeItemProvider == null) {
			hddDemandProbeItemProvider = new HDDDemandProbeItemProvider(this);
		}

		return hddDemandProbeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.HDDStateCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HDDStateCalculatorItemProvider hddStateCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.HDDStateCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHDDStateCalculatorAdapter() {
		if (hddStateCalculatorItemProvider == null) {
			hddStateCalculatorItemProvider = new HDDStateCalculatorItemProvider(this);
		}

		return hddStateCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.CPUStateCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CPUStateCalculatorItemProvider cpuStateCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.CPUStateCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCPUStateCalculatorAdapter() {
		if (cpuStateCalculatorItemProvider == null) {
			cpuStateCalculatorItemProvider = new CPUStateCalculatorItemProvider(this);
		}

		return cpuStateCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.CPUDemandCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CPUDemandCalculatorItemProvider cpuDemandCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.CPUDemandCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCPUDemandCalculatorAdapter() {
		if (cpuDemandCalculatorItemProvider == null) {
			cpuDemandCalculatorItemProvider = new CPUDemandCalculatorItemProvider(this);
		}

		return cpuDemandCalculatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probespec.HDDDemandCalculator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HDDDemandCalculatorItemProvider hddDemandCalculatorItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.probespec.HDDDemandCalculator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHDDDemandCalculatorAdapter() {
		if (hddDemandCalculatorItemProvider == null) {
			hddDemandCalculatorItemProvider = new HDDDemandCalculatorItemProvider(this);
		}

		return hddDemandCalculatorItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (passiveResourceCalculatorItemProvider != null) passiveResourceCalculatorItemProvider.dispose();
		if (probeSetItemProvider != null) probeSetItemProvider.dispose();
		if (passiveResourceStateProbeItemProvider != null) passiveResourceStateProbeItemProvider.dispose();
		if (stoExProbeItemProvider != null) stoExProbeItemProvider.dispose();
		if (seffParameterProbeItemProvider != null) seffParameterProbeItemProvider.dispose();
		if (currentTimeProbeItemProvider != null) currentTimeProbeItemProvider.dispose();
		if (stoExCalculatorItemProvider != null) stoExCalculatorItemProvider.dispose();
		if (seffParameterCalculatorItemProvider != null) seffParameterCalculatorItemProvider.dispose();
		if (responseTimeCalculatorItemProvider != null) responseTimeCalculatorItemProvider.dispose();
		if (waitingTimeCalculatorItemProvider != null) waitingTimeCalculatorItemProvider.dispose();
		if (probeSpecRepositoryItemProvider != null) probeSpecRepositoryItemProvider.dispose();
		if (cpuStateProbeItemProvider != null) cpuStateProbeItemProvider.dispose();
		if (hddStateProbeItemProvider != null) hddStateProbeItemProvider.dispose();
		if (cpuDemandProbeItemProvider != null) cpuDemandProbeItemProvider.dispose();
		if (hddDemandProbeItemProvider != null) hddDemandProbeItemProvider.dispose();
		if (hddStateCalculatorItemProvider != null) hddStateCalculatorItemProvider.dispose();
		if (cpuStateCalculatorItemProvider != null) cpuStateCalculatorItemProvider.dispose();
		if (cpuDemandCalculatorItemProvider != null) cpuDemandCalculatorItemProvider.dispose();
		if (hddDemandCalculatorItemProvider != null) hddDemandCalculatorItemProvider.dispose();
	}

}
