/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.seff;

import de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription;
import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Internal Action</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Internal Action Combines the execution of a number of internal computations by a component service in a single model entity. It models calculations inside a component service, which do not include calls to required services. For a desired high abstraction level, an RDSEFF has only one InternalAction for all instructions between two calls to required services. A high abstraction level is needed to keep the model tractable for mathematical analysis methods. However, in principle it is also possible to use multiple InternalActions in direct succession to model on a lower abstraction level and enable more accurate predictions.
 * InternalActions provide an abstraction from the complete behaviour (i.e., control and data flow) of a component service, as they can hide different possible control and data flows not affecting external service calls and express their resource demands as a single stochastic expression. This abstraction underlies the assumption that the resource demands of a number of instruction can be captured sufficiently accurate enough in one such expression
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.uka.ipd.sdq.pcm.seff.InternalAction#getFailureOccurrenceDescriptions_InternalAction <em>Failure Occurrence Descriptions Internal Action</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.uka.ipd.sdq.pcm.seff.SeffPackage#getInternalAction()
 * @model
 * @generated
 */
public interface InternalAction extends AbstractInternalControlFlowAction {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * Returns the value of the '<em><b>Failure Occurrence Descriptions Internal Action</b></em>' containment reference list.
	 * The list contents are of type {@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription}.
	 * It is bidirectional and its opposite is '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getInternalAction_FailureOccurenceDescription <em>Internal Action Failure Occurence Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Failure Occurrence Descriptions Internal Action</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Failure Occurrence Descriptions Internal Action</em>' containment reference list.
	 * @see de.uka.ipd.sdq.pcm.seff.SeffPackage#getInternalAction_FailureOccurrenceDescriptions_InternalAction()
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getInternalAction_FailureOccurenceDescription
	 * @model opposite="internalAction_FailureOccurenceDescription" containment="true" ordered="false"
	 * @generated
	 */
	EList<FailureOccurrenceDescription> getFailureOccurrenceDescriptions_InternalAction();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * self.failureOccurrenceDescriptions_InternalAction->forAll(x:pcm::reliability::FailureOccurrenceDescription,y:pcm::reliability::FailureOccurrenceDescription  | x<>y implies x.applicationFailureType_FailureOccurrenceDescription <> y.applicationFailureType_FailureOccurrenceDescription )
	 * 
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='self.failureOccurrenceDescriptions_InternalAction->forAll(x:pcm::reliability::FailureOccurrenceDescription,y:pcm::reliability::FailureOccurrenceDescription  | x<>y implies x.applicationFailureType_FailureOccurrenceDescription <> y.applicationFailureType_FailureOccurrenceDescription )\r\n'"
	 * @generated
	 */
	boolean Multipleusagesofsamefailuretypearenotallowed(DiagnosticChain diagnostics, Map<Object, Object> context);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * self.failureOccurrenceDescriptions_InternalAction.failureProbability.oclAsType(Real)->sum()<=1.0
	 * 
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='self.failureOccurrenceDescriptions_InternalAction.failureProbability.oclAsType(Real)->sum()<=1.0\r\n'"
	 * @generated
	 */
	boolean SumOfInternalActionFailureProbabilitiesMustNotExceed1(DiagnosticChain diagnostics, Map<Object, Object> context);

} // InternalAction
