/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.resourceenvironment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Container Operating System</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see de.uka.ipd.sdq.pcm.resourceenvironment.ResourceenvironmentPackage#getContainerOperatingSystem()
 * @model
 * @generated
 */
public enum ContainerOperatingSystem implements Enumerator {
	/**
	 * The '<em><b>WINDOWS VISTA</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_VISTA_VALUE
	 * @generated
	 * @ordered
	 */
	WINDOWS_VISTA(0, "WINDOWS_VISTA", "WINDOWS_VISTA"),

	/**
	 * The '<em><b>LINUX26 CFS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LINUX26_CFS_VALUE
	 * @generated
	 * @ordered
	 */
	LINUX26_CFS(1, "LINUX26_CFS", "LINUX26_CFS"),

	/**
	 * The '<em><b>LINUX26 O1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LINUX26_O1_VALUE
	 * @generated
	 * @ordered
	 */
	LINUX26_O1(2, "LINUX26_O1", "LINUX26_O1"),

	/**
	 * The '<em><b>WINDOWS XP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_XP_VALUE
	 * @generated
	 * @ordered
	 */
	WINDOWS_XP(3, "WINDOWS_XP", "WINDOWS_XP"),

	/**
	 * The '<em><b>WINDOWS 7</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_7_VALUE
	 * @generated
	 * @ordered
	 */
	WINDOWS_7(4, "WINDOWS_7", "WINDOWS_7"),

	/**
	 * The '<em><b>WINDOWS 2003</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_2003_VALUE
	 * @generated
	 * @ordered
	 */
	WINDOWS_2003(5, "WINDOWS_2003", "WINDOWS_2003"),

	/**
	 * The '<em><b>ABSTRACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ABSTRACT_VALUE
	 * @generated
	 * @ordered
	 */
	ABSTRACT(6, "ABSTRACT", "ABSTRACT");

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * The '<em><b>WINDOWS VISTA</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>WINDOWS VISTA</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_VISTA
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WINDOWS_VISTA_VALUE = 0;

	/**
	 * The '<em><b>LINUX26 CFS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LINUX26 CFS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LINUX26_CFS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LINUX26_CFS_VALUE = 1;

	/**
	 * The '<em><b>LINUX26 O1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LINUX26 O1</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LINUX26_O1
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LINUX26_O1_VALUE = 2;

	/**
	 * The '<em><b>WINDOWS XP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>WINDOWS XP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_XP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WINDOWS_XP_VALUE = 3;

	/**
	 * The '<em><b>WINDOWS 7</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>WINDOWS 7</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_7
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WINDOWS_7_VALUE = 4;

	/**
	 * The '<em><b>WINDOWS 2003</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>WINDOWS 2003</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WINDOWS_2003
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WINDOWS_2003_VALUE = 5;

	/**
	 * The '<em><b>ABSTRACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ABSTRACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ABSTRACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ABSTRACT_VALUE = 6;

	/**
	 * An array of all the '<em><b>Container Operating System</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ContainerOperatingSystem[] VALUES_ARRAY =
		new ContainerOperatingSystem[] {
			WINDOWS_VISTA,
			LINUX26_CFS,
			LINUX26_O1,
			WINDOWS_XP,
			WINDOWS_7,
			WINDOWS_2003,
			ABSTRACT,
		};

	/**
	 * A public read-only list of all the '<em><b>Container Operating System</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ContainerOperatingSystem> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Container Operating System</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ContainerOperatingSystem get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ContainerOperatingSystem result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Container Operating System</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ContainerOperatingSystem getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ContainerOperatingSystem result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Container Operating System</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ContainerOperatingSystem get(int value) {
		switch (value) {
			case WINDOWS_VISTA_VALUE: return WINDOWS_VISTA;
			case LINUX26_CFS_VALUE: return LINUX26_CFS;
			case LINUX26_O1_VALUE: return LINUX26_O1;
			case WINDOWS_XP_VALUE: return WINDOWS_XP;
			case WINDOWS_7_VALUE: return WINDOWS_7;
			case WINDOWS_2003_VALUE: return WINDOWS_2003;
			case ABSTRACT_VALUE: return ABSTRACT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ContainerOperatingSystem(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ContainerOperatingSystem
