/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.reliability.impl;

import de.uka.ipd.sdq.pcm.qosannotations.reliability.SpecifiedReliabilityAnnotation;

import de.uka.ipd.sdq.pcm.reliability.ApplicationFailureType;
import de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription;
import de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage;

import de.uka.ipd.sdq.pcm.reliability.util.ReliabilityValidator;
import de.uka.ipd.sdq.pcm.seff.InternalAction;
import de.uka.ipd.sdq.pcm.seff.SeffPackage;

import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Failure Occurrence Description</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl#getFailureProbability <em>Failure Probability</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl#getInternalAction_FailureOccurenceDescription <em>Internal Action Failure Occurence Description</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription <em>Specified Reliability Annotation Failure Occurrence Description</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl#getApplicationFailureType_FailureOccurrenceDescription <em>Application Failure Type Failure Occurrence Description</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FailureOccurrenceDescriptionImpl extends EObjectImpl implements FailureOccurrenceDescription {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * The default value of the '{@link #getFailureProbability() <em>Failure Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFailureProbability()
	 * @generated
	 * @ordered
	 */
	protected static final double FAILURE_PROBABILITY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getFailureProbability() <em>Failure Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFailureProbability()
	 * @generated
	 * @ordered
	 */
	protected double failureProbability = FAILURE_PROBABILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getApplicationFailureType_FailureOccurrenceDescription() <em>Application Failure Type Failure Occurrence Description</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getApplicationFailureType_FailureOccurrenceDescription()
	 * @generated
	 * @ordered
	 */
	protected ApplicationFailureType applicationFailureType_FailureOccurrenceDescription;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FailureOccurrenceDescriptionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ReliabilityPackage.Literals.FAILURE_OCCURRENCE_DESCRIPTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getFailureProbability() {
		return failureProbability;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFailureProbability(double newFailureProbability) {
		double oldFailureProbability = failureProbability;
		failureProbability = newFailureProbability;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__FAILURE_PROBABILITY, oldFailureProbability, failureProbability));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InternalAction getInternalAction_FailureOccurenceDescription() {
		if (eContainerFeatureID() != ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION) return null;
		return (InternalAction)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInternalAction_FailureOccurenceDescription(InternalAction newInternalAction_FailureOccurenceDescription, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newInternalAction_FailureOccurenceDescription, ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInternalAction_FailureOccurenceDescription(InternalAction newInternalAction_FailureOccurenceDescription) {
		if (newInternalAction_FailureOccurenceDescription != eInternalContainer() || (eContainerFeatureID() != ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION && newInternalAction_FailureOccurenceDescription != null)) {
			if (EcoreUtil.isAncestor(this, newInternalAction_FailureOccurenceDescription))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newInternalAction_FailureOccurenceDescription != null)
				msgs = ((InternalEObject)newInternalAction_FailureOccurenceDescription).eInverseAdd(this, SeffPackage.INTERNAL_ACTION__FAILURE_OCCURRENCE_DESCRIPTIONS_INTERNAL_ACTION, InternalAction.class, msgs);
			msgs = basicSetInternalAction_FailureOccurenceDescription(newInternalAction_FailureOccurenceDescription, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION, newInternalAction_FailureOccurenceDescription, newInternalAction_FailureOccurenceDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SpecifiedReliabilityAnnotation getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription() {
		if (eContainerFeatureID() != ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION) return null;
		return (SpecifiedReliabilityAnnotation)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSpecifiedReliabilityAnnotation_FailureOccurrenceDescription(SpecifiedReliabilityAnnotation newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription, ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSpecifiedReliabilityAnnotation_FailureOccurrenceDescription(SpecifiedReliabilityAnnotation newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription) {
		if (newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription != eInternalContainer() || (eContainerFeatureID() != ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION && newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription != null)) {
			if (EcoreUtil.isAncestor(this, newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription != null)
				msgs = ((InternalEObject)newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription).eInverseAdd(this, de.uka.ipd.sdq.pcm.qosannotations.reliability.ReliabilityPackage.SPECIFIED_RELIABILITY_ANNOTATION__FAILURE_OCCURRENCE_DESCRIPTIONS_SPECIFIED_RELIABILITY_ANNOTATION, SpecifiedReliabilityAnnotation.class, msgs);
			msgs = basicSetSpecifiedReliabilityAnnotation_FailureOccurrenceDescription(newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION, newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription, newSpecifiedReliabilityAnnotation_FailureOccurrenceDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApplicationFailureType getApplicationFailureType_FailureOccurrenceDescription() {
		if (applicationFailureType_FailureOccurrenceDescription != null && applicationFailureType_FailureOccurrenceDescription.eIsProxy()) {
			InternalEObject oldApplicationFailureType_FailureOccurrenceDescription = (InternalEObject)applicationFailureType_FailureOccurrenceDescription;
			applicationFailureType_FailureOccurrenceDescription = (ApplicationFailureType)eResolveProxy(oldApplicationFailureType_FailureOccurrenceDescription);
			if (applicationFailureType_FailureOccurrenceDescription != oldApplicationFailureType_FailureOccurrenceDescription) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION, oldApplicationFailureType_FailureOccurrenceDescription, applicationFailureType_FailureOccurrenceDescription));
			}
		}
		return applicationFailureType_FailureOccurrenceDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApplicationFailureType basicGetApplicationFailureType_FailureOccurrenceDescription() {
		return applicationFailureType_FailureOccurrenceDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setApplicationFailureType_FailureOccurrenceDescription(ApplicationFailureType newApplicationFailureType_FailureOccurrenceDescription) {
		ApplicationFailureType oldApplicationFailureType_FailureOccurrenceDescription = applicationFailureType_FailureOccurrenceDescription;
		applicationFailureType_FailureOccurrenceDescription = newApplicationFailureType_FailureOccurrenceDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION, oldApplicationFailureType_FailureOccurrenceDescription, applicationFailureType_FailureOccurrenceDescription));
	}

	/**
	 * The cached OCL expression body for the '{@link #EnsureValidFailureProbabilityRange(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Ensure Valid Failure Probability Range</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EnsureValidFailureProbabilityRange(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String ENSURE_VALID_FAILURE_PROBABILITY_RANGE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "(self.failureProbability.oclAsType(Real) <= 1.0) and (self.failureProbability.oclAsType(Real) >= 0.0)";

	/**
	 * The cached OCL invariant for the '{@link #EnsureValidFailureProbabilityRange(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Ensure Valid Failure Probability Range</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EnsureValidFailureProbabilityRange(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint ENSURE_VALID_FAILURE_PROBABILITY_RANGE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean EnsureValidFailureProbabilityRange(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (ENSURE_VALID_FAILURE_PROBABILITY_RANGE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(ReliabilityPackage.Literals.FAILURE_OCCURRENCE_DESCRIPTION);
			try {
				ENSURE_VALID_FAILURE_PROBABILITY_RANGE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(ENSURE_VALID_FAILURE_PROBABILITY_RANGE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(ENSURE_VALID_FAILURE_PROBABILITY_RANGE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 ReliabilityValidator.DIAGNOSTIC_SOURCE,
						 ReliabilityValidator.FAILURE_OCCURRENCE_DESCRIPTION__ENSURE_VALID_FAILURE_PROBABILITY_RANGE,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "EnsureValidFailureProbabilityRange", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetInternalAction_FailureOccurenceDescription((InternalAction)otherEnd, msgs);
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSpecifiedReliabilityAnnotation_FailureOccurrenceDescription((SpecifiedReliabilityAnnotation)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION:
				return basicSetInternalAction_FailureOccurenceDescription(null, msgs);
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION:
				return basicSetSpecifiedReliabilityAnnotation_FailureOccurrenceDescription(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION:
				return eInternalContainer().eInverseRemove(this, SeffPackage.INTERNAL_ACTION__FAILURE_OCCURRENCE_DESCRIPTIONS_INTERNAL_ACTION, InternalAction.class, msgs);
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION:
				return eInternalContainer().eInverseRemove(this, de.uka.ipd.sdq.pcm.qosannotations.reliability.ReliabilityPackage.SPECIFIED_RELIABILITY_ANNOTATION__FAILURE_OCCURRENCE_DESCRIPTIONS_SPECIFIED_RELIABILITY_ANNOTATION, SpecifiedReliabilityAnnotation.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__FAILURE_PROBABILITY:
				return getFailureProbability();
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION:
				return getInternalAction_FailureOccurenceDescription();
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION:
				return getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription();
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION:
				if (resolve) return getApplicationFailureType_FailureOccurrenceDescription();
				return basicGetApplicationFailureType_FailureOccurrenceDescription();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__FAILURE_PROBABILITY:
				setFailureProbability((Double)newValue);
				return;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION:
				setInternalAction_FailureOccurenceDescription((InternalAction)newValue);
				return;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION:
				setSpecifiedReliabilityAnnotation_FailureOccurrenceDescription((SpecifiedReliabilityAnnotation)newValue);
				return;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION:
				setApplicationFailureType_FailureOccurrenceDescription((ApplicationFailureType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__FAILURE_PROBABILITY:
				setFailureProbability(FAILURE_PROBABILITY_EDEFAULT);
				return;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION:
				setInternalAction_FailureOccurenceDescription((InternalAction)null);
				return;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION:
				setSpecifiedReliabilityAnnotation_FailureOccurrenceDescription((SpecifiedReliabilityAnnotation)null);
				return;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION:
				setApplicationFailureType_FailureOccurrenceDescription((ApplicationFailureType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__FAILURE_PROBABILITY:
				return failureProbability != FAILURE_PROBABILITY_EDEFAULT;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION:
				return getInternalAction_FailureOccurenceDescription() != null;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION:
				return getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription() != null;
			case ReliabilityPackage.FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION:
				return applicationFailureType_FailureOccurrenceDescription != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (failureProbability: ");
		result.append(failureProbability);
		result.append(')');
		return result.toString();
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //FailureOccurrenceDescriptionImpl
