/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.reliability.impl;

import de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType;
import de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage;

import de.uka.ipd.sdq.pcm.reliability.util.ReliabilityValidator;

import de.uka.ipd.sdq.pcm.resourcetype.ProcessingResourceType;

import java.util.Map;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.eclipse.ocl.ParserException;

import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Environment Failure Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.impl.EnvironmentFailureTypeImpl#getProcessingResourceType_EnvironmentFailureType <em>Processing Resource Type Environment Failure Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EnvironmentFailureTypeImpl extends StopFailureTypeImpl implements EnvironmentFailureType {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * The cached value of the '{@link #getProcessingResourceType_EnvironmentFailureType() <em>Processing Resource Type Environment Failure Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessingResourceType_EnvironmentFailureType()
	 * @generated
	 * @ordered
	 */
	protected ProcessingResourceType processingResourceType_EnvironmentFailureType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnvironmentFailureTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ReliabilityPackage.Literals.ENVIRONMENT_FAILURE_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessingResourceType getProcessingResourceType_EnvironmentFailureType() {
		if (processingResourceType_EnvironmentFailureType != null && processingResourceType_EnvironmentFailureType.eIsProxy()) {
			InternalEObject oldProcessingResourceType_EnvironmentFailureType = (InternalEObject)processingResourceType_EnvironmentFailureType;
			processingResourceType_EnvironmentFailureType = (ProcessingResourceType)eResolveProxy(oldProcessingResourceType_EnvironmentFailureType);
			if (processingResourceType_EnvironmentFailureType != oldProcessingResourceType_EnvironmentFailureType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ReliabilityPackage.ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE, oldProcessingResourceType_EnvironmentFailureType, processingResourceType_EnvironmentFailureType));
			}
		}
		return processingResourceType_EnvironmentFailureType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessingResourceType basicGetProcessingResourceType_EnvironmentFailureType() {
		return processingResourceType_EnvironmentFailureType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessingResourceType_EnvironmentFailureType(ProcessingResourceType newProcessingResourceType_EnvironmentFailureType) {
		ProcessingResourceType oldProcessingResourceType_EnvironmentFailureType = processingResourceType_EnvironmentFailureType;
		processingResourceType_EnvironmentFailureType = newProcessingResourceType_EnvironmentFailureType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReliabilityPackage.ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE, oldProcessingResourceType_EnvironmentFailureType, processingResourceType_EnvironmentFailureType));
	}

	/**
	 * The cached OCL expression body for the '{@link #ExactlyOneResource(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Exactly One Resource</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ExactlyOneResource(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String EXACTLY_ONE_RESOURCE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.processingResourceType_EnvironmentFailureType <> null";

	/**
	 * The cached OCL invariant for the '{@link #ExactlyOneResource(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Exactly One Resource</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ExactlyOneResource(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint EXACTLY_ONE_RESOURCE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean ExactlyOneResource(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (EXACTLY_ONE_RESOURCE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(ReliabilityPackage.Literals.ENVIRONMENT_FAILURE_TYPE);
			try {
				EXACTLY_ONE_RESOURCE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(EXACTLY_ONE_RESOURCE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(EXACTLY_ONE_RESOURCE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 ReliabilityValidator.DIAGNOSTIC_SOURCE,
						 ReliabilityValidator.ENVIRONMENT_FAILURE_TYPE__EXACTLY_ONE_RESOURCE,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "ExactlyOneResource", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ReliabilityPackage.ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE:
				if (resolve) return getProcessingResourceType_EnvironmentFailureType();
				return basicGetProcessingResourceType_EnvironmentFailureType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ReliabilityPackage.ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE:
				setProcessingResourceType_EnvironmentFailureType((ProcessingResourceType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ReliabilityPackage.ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE:
				setProcessingResourceType_EnvironmentFailureType((ProcessingResourceType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ReliabilityPackage.ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE:
				return processingResourceType_EnvironmentFailureType != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //EnvironmentFailureTypeImpl
