/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.reliability;

import de.uka.ipd.sdq.pcm.core.entity.EntityPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This package contains reliability-relevant classes such as the definition of failure types.
 * <!-- end-model-doc -->
 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityFactory
 * @model kind="package"
 * @generated
 */
public interface ReliabilityPackage extends EPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "reliability";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://sdq.ipd.uka.de/PalladioComponentModel/Reliability/4.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "pcm.reliability";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ReliabilityPackage eINSTANCE = de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl <em>Failure Occurrence Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getFailureOccurrenceDescription()
	 * @generated
	 */
	int FAILURE_OCCURRENCE_DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Failure Probability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_OCCURRENCE_DESCRIPTION__FAILURE_PROBABILITY = 0;

	/**
	 * The feature id for the '<em><b>Internal Action Failure Occurence Description</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Specified Reliability Annotation Failure Occurrence Description</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Application Failure Type Failure Occurrence Description</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION = 3;

	/**
	 * The number of structural features of the '<em>Failure Occurrence Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_OCCURRENCE_DESCRIPTION_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureTypeImpl <em>Failure Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.FailureTypeImpl
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getFailureType()
	 * @generated
	 */
	int FAILURE_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_TYPE__ID = EntityPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_TYPE__ENTITY_NAME = EntityPackage.ENTITY__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Repository Failure Type</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_TYPE__REPOSITORY_FAILURE_TYPE = EntityPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Failure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILURE_TYPE_FEATURE_COUNT = EntityPackage.ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.StopFailureTypeImpl <em>Stop Failure Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.StopFailureTypeImpl
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getStopFailureType()
	 * @generated
	 */
	int STOP_FAILURE_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_FAILURE_TYPE__ID = FAILURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_FAILURE_TYPE__ENTITY_NAME = FAILURE_TYPE__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Repository Failure Type</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_FAILURE_TYPE__REPOSITORY_FAILURE_TYPE = FAILURE_TYPE__REPOSITORY_FAILURE_TYPE;

	/**
	 * The number of structural features of the '<em>Stop Failure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_FAILURE_TYPE_FEATURE_COUNT = FAILURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.ApplicationFailureTypeImpl <em>Application Failure Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.ApplicationFailureTypeImpl
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getApplicationFailureType()
	 * @generated
	 */
	int APPLICATION_FAILURE_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_FAILURE_TYPE__ID = STOP_FAILURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_FAILURE_TYPE__ENTITY_NAME = STOP_FAILURE_TYPE__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Repository Failure Type</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_FAILURE_TYPE__REPOSITORY_FAILURE_TYPE = STOP_FAILURE_TYPE__REPOSITORY_FAILURE_TYPE;

	/**
	 * The number of structural features of the '<em>Application Failure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_FAILURE_TYPE_FEATURE_COUNT = STOP_FAILURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.EnvironmentFailureTypeImpl <em>Environment Failure Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.EnvironmentFailureTypeImpl
	 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getEnvironmentFailureType()
	 * @generated
	 */
	int ENVIRONMENT_FAILURE_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVIRONMENT_FAILURE_TYPE__ID = STOP_FAILURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVIRONMENT_FAILURE_TYPE__ENTITY_NAME = STOP_FAILURE_TYPE__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Repository Failure Type</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVIRONMENT_FAILURE_TYPE__REPOSITORY_FAILURE_TYPE = STOP_FAILURE_TYPE__REPOSITORY_FAILURE_TYPE;

	/**
	 * The feature id for the '<em><b>Processing Resource Type Environment Failure Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE = STOP_FAILURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Environment Failure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVIRONMENT_FAILURE_TYPE_FEATURE_COUNT = STOP_FAILURE_TYPE_FEATURE_COUNT + 1;


	/**
	 * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription <em>Failure Occurrence Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Failure Occurrence Description</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription
	 * @generated
	 */
	EClass getFailureOccurrenceDescription();

	/**
	 * Returns the meta object for the attribute '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getFailureProbability <em>Failure Probability</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Failure Probability</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getFailureProbability()
	 * @see #getFailureOccurrenceDescription()
	 * @generated
	 */
	EAttribute getFailureOccurrenceDescription_FailureProbability();

	/**
	 * Returns the meta object for the container reference '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getInternalAction_FailureOccurenceDescription <em>Internal Action Failure Occurence Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Internal Action Failure Occurence Description</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getInternalAction_FailureOccurenceDescription()
	 * @see #getFailureOccurrenceDescription()
	 * @generated
	 */
	EReference getFailureOccurrenceDescription_InternalAction_FailureOccurenceDescription();

	/**
	 * Returns the meta object for the container reference '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription <em>Specified Reliability Annotation Failure Occurrence Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Specified Reliability Annotation Failure Occurrence Description</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription()
	 * @see #getFailureOccurrenceDescription()
	 * @generated
	 */
	EReference getFailureOccurrenceDescription_SpecifiedReliabilityAnnotation_FailureOccurrenceDescription();

	/**
	 * Returns the meta object for the reference '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getApplicationFailureType_FailureOccurrenceDescription <em>Application Failure Type Failure Occurrence Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Application Failure Type Failure Occurrence Description</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getApplicationFailureType_FailureOccurrenceDescription()
	 * @see #getFailureOccurrenceDescription()
	 * @generated
	 */
	EReference getFailureOccurrenceDescription_ApplicationFailureType_FailureOccurrenceDescription();

	/**
	 * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.reliability.ApplicationFailureType <em>Application Failure Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Application Failure Type</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.ApplicationFailureType
	 * @generated
	 */
	EClass getApplicationFailureType();

	/**
	 * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.reliability.StopFailureType <em>Stop Failure Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Stop Failure Type</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.StopFailureType
	 * @generated
	 */
	EClass getStopFailureType();

	/**
	 * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType <em>Environment Failure Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Environment Failure Type</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType
	 * @generated
	 */
	EClass getEnvironmentFailureType();

	/**
	 * Returns the meta object for the reference '{@link de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType#getProcessingResourceType_EnvironmentFailureType <em>Processing Resource Type Environment Failure Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Processing Resource Type Environment Failure Type</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType#getProcessingResourceType_EnvironmentFailureType()
	 * @see #getEnvironmentFailureType()
	 * @generated
	 */
	EReference getEnvironmentFailureType_ProcessingResourceType_EnvironmentFailureType();

	/**
	 * Returns the meta object for class '{@link de.uka.ipd.sdq.pcm.reliability.FailureType <em>Failure Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Failure Type</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureType
	 * @generated
	 */
	EClass getFailureType();

	/**
	 * Returns the meta object for the container reference '{@link de.uka.ipd.sdq.pcm.reliability.FailureType#getRepository_FailureType <em>Repository Failure Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Repository Failure Type</em>'.
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureType#getRepository_FailureType()
	 * @see #getFailureType()
	 * @generated
	 */
	EReference getFailureType_Repository_FailureType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ReliabilityFactory getReliabilityFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl <em>Failure Occurrence Description</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.FailureOccurrenceDescriptionImpl
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getFailureOccurrenceDescription()
		 * @generated
		 */
		EClass FAILURE_OCCURRENCE_DESCRIPTION = eINSTANCE.getFailureOccurrenceDescription();

		/**
		 * The meta object literal for the '<em><b>Failure Probability</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FAILURE_OCCURRENCE_DESCRIPTION__FAILURE_PROBABILITY = eINSTANCE.getFailureOccurrenceDescription_FailureProbability();

		/**
		 * The meta object literal for the '<em><b>Internal Action Failure Occurence Description</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FAILURE_OCCURRENCE_DESCRIPTION__INTERNAL_ACTION_FAILURE_OCCURENCE_DESCRIPTION = eINSTANCE.getFailureOccurrenceDescription_InternalAction_FailureOccurenceDescription();

		/**
		 * The meta object literal for the '<em><b>Specified Reliability Annotation Failure Occurrence Description</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FAILURE_OCCURRENCE_DESCRIPTION__SPECIFIED_RELIABILITY_ANNOTATION_FAILURE_OCCURRENCE_DESCRIPTION = eINSTANCE.getFailureOccurrenceDescription_SpecifiedReliabilityAnnotation_FailureOccurrenceDescription();

		/**
		 * The meta object literal for the '<em><b>Application Failure Type Failure Occurrence Description</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FAILURE_OCCURRENCE_DESCRIPTION__APPLICATION_FAILURE_TYPE_FAILURE_OCCURRENCE_DESCRIPTION = eINSTANCE.getFailureOccurrenceDescription_ApplicationFailureType_FailureOccurrenceDescription();

		/**
		 * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.ApplicationFailureTypeImpl <em>Application Failure Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.ApplicationFailureTypeImpl
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getApplicationFailureType()
		 * @generated
		 */
		EClass APPLICATION_FAILURE_TYPE = eINSTANCE.getApplicationFailureType();

		/**
		 * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.StopFailureTypeImpl <em>Stop Failure Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.StopFailureTypeImpl
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getStopFailureType()
		 * @generated
		 */
		EClass STOP_FAILURE_TYPE = eINSTANCE.getStopFailureType();

		/**
		 * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.EnvironmentFailureTypeImpl <em>Environment Failure Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.EnvironmentFailureTypeImpl
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getEnvironmentFailureType()
		 * @generated
		 */
		EClass ENVIRONMENT_FAILURE_TYPE = eINSTANCE.getEnvironmentFailureType();

		/**
		 * The meta object literal for the '<em><b>Processing Resource Type Environment Failure Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENVIRONMENT_FAILURE_TYPE__PROCESSING_RESOURCE_TYPE_ENVIRONMENT_FAILURE_TYPE = eINSTANCE.getEnvironmentFailureType_ProcessingResourceType_EnvironmentFailureType();

		/**
		 * The meta object literal for the '{@link de.uka.ipd.sdq.pcm.reliability.impl.FailureTypeImpl <em>Failure Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.FailureTypeImpl
		 * @see de.uka.ipd.sdq.pcm.reliability.impl.ReliabilityPackageImpl#getFailureType()
		 * @generated
		 */
		EClass FAILURE_TYPE = eINSTANCE.getFailureType();

		/**
		 * The meta object literal for the '<em><b>Repository Failure Type</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FAILURE_TYPE__REPOSITORY_FAILURE_TYPE = eINSTANCE.getFailureType_Repository_FailureType();

	}

} //ReliabilityPackage
