/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.reliability;

import de.uka.ipd.sdq.pcm.qosannotations.reliability.SpecifiedReliabilityAnnotation;

import de.uka.ipd.sdq.pcm.seff.InternalAction;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Failure Occurrence Description</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * <p>
 *     Describes the occurrence probability of failures of a specified type.&nbsp;In one&nbsp;InternalAction the&nbsp;sum of
 *     all failure probabilities must&nbsp;be less than&nbsp;or&nbsp;equal 1.0. Internal actions may only have one failure
 *     occurrence descripton for a failure type. (see constraints)
 * </p>
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getFailureProbability <em>Failure Probability</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getInternalAction_FailureOccurenceDescription <em>Internal Action Failure Occurence Description</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription <em>Specified Reliability Annotation Failure Occurrence Description</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getApplicationFailureType_FailureOccurrenceDescription <em>Application Failure Type Failure Occurrence Description</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage#getFailureOccurrenceDescription()
 * @model
 * @generated
 */
public interface FailureOccurrenceDescription extends EObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * Returns the value of the '<em><b>Failure Probability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Failure Probability</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Failure Probability</em>' attribute.
	 * @see #setFailureProbability(double)
	 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage#getFailureOccurrenceDescription_FailureProbability()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	double getFailureProbability();

	/**
	 * Sets the value of the '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getFailureProbability <em>Failure Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Failure Probability</em>' attribute.
	 * @see #getFailureProbability()
	 * @generated
	 */
	void setFailureProbability(double value);

	/**
	 * Returns the value of the '<em><b>Internal Action Failure Occurence Description</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.uka.ipd.sdq.pcm.seff.InternalAction#getFailureOccurrenceDescriptions_InternalAction <em>Failure Occurrence Descriptions Internal Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Internal Action Failure Occurence Description</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Internal Action Failure Occurence Description</em>' container reference.
	 * @see #setInternalAction_FailureOccurenceDescription(InternalAction)
	 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage#getFailureOccurrenceDescription_InternalAction_FailureOccurenceDescription()
	 * @see de.uka.ipd.sdq.pcm.seff.InternalAction#getFailureOccurrenceDescriptions_InternalAction
	 * @model opposite="failureOccurrenceDescriptions_InternalAction" transient="false" ordered="false"
	 * @generated
	 */
	InternalAction getInternalAction_FailureOccurenceDescription();

	/**
	 * Sets the value of the '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getInternalAction_FailureOccurenceDescription <em>Internal Action Failure Occurence Description</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Internal Action Failure Occurence Description</em>' container reference.
	 * @see #getInternalAction_FailureOccurenceDescription()
	 * @generated
	 */
	void setInternalAction_FailureOccurenceDescription(InternalAction value);

	/**
	 * Returns the value of the '<em><b>Specified Reliability Annotation Failure Occurrence Description</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.uka.ipd.sdq.pcm.qosannotations.reliability.SpecifiedReliabilityAnnotation#getFailureOccurrenceDescriptions_SpecifiedReliabilityAnnotation <em>Failure Occurrence Descriptions Specified Reliability Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Specified Reliability Annotation Failure Occurrence Description</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Specified Reliability Annotation Failure Occurrence Description</em>' container reference.
	 * @see #setSpecifiedReliabilityAnnotation_FailureOccurrenceDescription(SpecifiedReliabilityAnnotation)
	 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage#getFailureOccurrenceDescription_SpecifiedReliabilityAnnotation_FailureOccurrenceDescription()
	 * @see de.uka.ipd.sdq.pcm.qosannotations.reliability.SpecifiedReliabilityAnnotation#getFailureOccurrenceDescriptions_SpecifiedReliabilityAnnotation
	 * @model opposite="failureOccurrenceDescriptions_SpecifiedReliabilityAnnotation" transient="false" ordered="false"
	 * @generated
	 */
	SpecifiedReliabilityAnnotation getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription();

	/**
	 * Sets the value of the '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription <em>Specified Reliability Annotation Failure Occurrence Description</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Specified Reliability Annotation Failure Occurrence Description</em>' container reference.
	 * @see #getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription()
	 * @generated
	 */
	void setSpecifiedReliabilityAnnotation_FailureOccurrenceDescription(SpecifiedReliabilityAnnotation value);

	/**
	 * Returns the value of the '<em><b>Application Failure Type Failure Occurrence Description</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Application Failure Type Failure Occurrence Description</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Application Failure Type Failure Occurrence Description</em>' reference.
	 * @see #setApplicationFailureType_FailureOccurrenceDescription(ApplicationFailureType)
	 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage#getFailureOccurrenceDescription_ApplicationFailureType_FailureOccurrenceDescription()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ApplicationFailureType getApplicationFailureType_FailureOccurrenceDescription();

	/**
	 * Sets the value of the '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getApplicationFailureType_FailureOccurrenceDescription <em>Application Failure Type Failure Occurrence Description</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Application Failure Type Failure Occurrence Description</em>' reference.
	 * @see #getApplicationFailureType_FailureOccurrenceDescription()
	 * @generated
	 */
	void setApplicationFailureType_FailureOccurrenceDescription(ApplicationFailureType value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * (self.failureProbability.oclAsType(Real) <= 1.0) and (self.failureProbability.oclAsType(Real) >= 0.0)
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='(self.failureProbability.oclAsType(Real) <= 1.0) and (self.failureProbability.oclAsType(Real) >= 0.0)'"
	 * @generated
	 */
	boolean EnsureValidFailureProbabilityRange(DiagnosticChain diagnostics, Map<Object, Object> context);

} // FailureOccurrenceDescription
