/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.reliability;

import de.uka.ipd.sdq.pcm.resourcetype.ProcessingResourceType;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Environment Failure Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Environment failure are caused by unavailable or malfunctioning resources. The EnvironmentFailureType represents a failure
 * of a specific resource type.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType#getProcessingResourceType_EnvironmentFailureType <em>Processing Resource Type Environment Failure Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage#getEnvironmentFailureType()
 * @model
 * @generated
 */
public interface EnvironmentFailureType extends StopFailureType {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * Returns the value of the '<em><b>Processing Resource Type Environment Failure Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Processing Resource Type Environment Failure Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Processing Resource Type Environment Failure Type</em>' reference.
	 * @see #setProcessingResourceType_EnvironmentFailureType(ProcessingResourceType)
	 * @see de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage#getEnvironmentFailureType_ProcessingResourceType_EnvironmentFailureType()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ProcessingResourceType getProcessingResourceType_EnvironmentFailureType();

	/**
	 * Sets the value of the '{@link de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType#getProcessingResourceType_EnvironmentFailureType <em>Processing Resource Type Environment Failure Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Processing Resource Type Environment Failure Type</em>' reference.
	 * @see #getProcessingResourceType_EnvironmentFailureType()
	 * @generated
	 */
	void setProcessingResourceType_EnvironmentFailureType(ProcessingResourceType value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * self.processingResourceType_EnvironmentFailureType <> null
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='self.processingResourceType_EnvironmentFailureType <> null'"
	 * @generated
	 */
	boolean ExactlyOneResource(DiagnosticChain diagnostics, Map<Object, Object> context);

} // EnvironmentFailureType
