/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.qosannotations.reliability;

import de.uka.ipd.sdq.pcm.qosannotations.SpecifiedQoSAnnotation;

import de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Specified Reliability Annotation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A SpecifiedFailureProbability of a service resembles its "Probability of Failure on Demand" (POFOD). Whenever the service is called, this values states the probability that it returns successfully. For reliability prediction, the PCMRandomVariable specified in its superclass SpecifiedQoSAnnotation must evaluate to a real number between 0 and 1.
 * 
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.uka.ipd.sdq.pcm.qosannotations.reliability.SpecifiedReliabilityAnnotation#getFailureOccurrenceDescriptions_SpecifiedReliabilityAnnotation <em>Failure Occurrence Descriptions Specified Reliability Annotation</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.uka.ipd.sdq.pcm.qosannotations.reliability.ReliabilityPackage#getSpecifiedReliabilityAnnotation()
 * @model
 * @generated
 */
public interface SpecifiedReliabilityAnnotation extends SpecifiedQoSAnnotation {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";

	/**
	 * Returns the value of the '<em><b>Failure Occurrence Descriptions Specified Reliability Annotation</b></em>' containment reference list.
	 * The list contents are of type {@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription}.
	 * It is bidirectional and its opposite is '{@link de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription <em>Specified Reliability Annotation Failure Occurrence Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Failure Occurrence Descriptions Specified Reliability Annotation</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Failure Occurrence Descriptions Specified Reliability Annotation</em>' containment reference list.
	 * @see de.uka.ipd.sdq.pcm.qosannotations.reliability.ReliabilityPackage#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescriptions_SpecifiedReliabilityAnnotation()
	 * @see de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription#getSpecifiedReliabilityAnnotation_FailureOccurrenceDescription
	 * @model opposite="specifiedReliabilityAnnotation_FailureOccurrenceDescription" containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<FailureOccurrenceDescription> getFailureOccurrenceDescriptions_SpecifiedReliabilityAnnotation();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * (self.role_SpecifiedQoSAnnotation.oclIsTypeOf(pcm::repository::OperationRequiredRole)) and (self.role_SpecifiedQoSAnnotation.oclAsType(pcm::repository::OperationRequiredRole).requiringEntity_RequiredRole.oclIsTypeOf(pcm::system::System))
	 * 
	 * 
	 * 
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='(self.role_SpecifiedQoSAnnotation.oclIsTypeOf(pcm::repository::OperationRequiredRole)) and (self.role_SpecifiedQoSAnnotation.oclAsType(pcm::repository::OperationRequiredRole).requiringEntity_RequiredRole.oclIsTypeOf(pcm::system::System))\r\n\r\n\r\n'"
	 * @generated
	 */
	boolean SpecifiedReliabilityAnnotationMustReferenceRequiredRoleOfASystem(DiagnosticChain diagnostics, Map<Object, Object> context);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * self.failureOccurrenceDescriptions_SpecifiedReliabilityAnnotation.failureProbability.oclAsType(Real)->sum()<=1.0
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='self.failureOccurrenceDescriptions_SpecifiedReliabilityAnnotation.failureProbability.oclAsType(Real)->sum()<=1.0'"
	 * @generated
	 */
	boolean SumOfReliabilityAnnotationFailureProbabilitiesMustNotExceed1(DiagnosticChain diagnostics, Map<Object, Object> context);

} // SpecifiedReliabilityAnnotation
