/*
 * Copyright 2006 SDQ Research Group, University of Karlsruhe (TH)
 */
package de.uka.ipd.sdq.pcm.gmf.seff.edit.parts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;

import de.uka.ipd.sdq.pcm.gmf.seff.edit.policies.ProbabilisticBranchTransitionCanonicalEditPolicy;
import de.uka.ipd.sdq.pcm.gmf.seff.edit.policies.ProbabilisticBranchTransitionItemSemanticEditPolicy;
import de.uka.ipd.sdq.pcm.gmf.seff.part.PalladioComponentModelVisualIDRegistry;

/**
 * @generated
 */
public class ProbabilisticBranchTransitionEditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 3010;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public ProbabilisticBranchTransitionEditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		installEditPolicy(EditPolicyRoles.CREATION_ROLE,
				new CreationEditPolicy());
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new ProbabilisticBranchTransitionItemSemanticEditPolicy());
		installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE,
				new DragDropEditPolicy());
		installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
				new ProbabilisticBranchTransitionCanonicalEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child
						.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		BranchTransitionFigure figure = new BranchTransitionFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public BranchTransitionFigure getPrimaryShape() {
		return (BranchTransitionFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof ProbabilisticBranchTransitionEntityNameEditPart) {
			((ProbabilisticBranchTransitionEntityNameEditPart) childEditPart)
					.setLabel(getPrimaryShape()
							.getFigureBranchTransitionNameLabel());
			return true;
		}
		if (childEditPart instanceof ProbabilisticBranchTransitionBranchProbabilityEditPart) {
			((ProbabilisticBranchTransitionBranchProbabilityEditPart) childEditPart)
					.setLabel(getPrimaryShape()
							.getFigureBranchTransitionProbabilityLabel());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof ProbabilisticBranchTransitionEntityNameEditPart) {
			return true;
		}
		if (childEditPart instanceof ProbabilisticBranchTransitionBranchProbabilityEditPart) {
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
		return getContentPane();
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(5);
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	protected void setForegroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setForegroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setBackgroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setBackgroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineWidth(int width) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineWidth(width);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineType(int style) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineStyle(style);
		}
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(PalladioComponentModelVisualIDRegistry
				.getType(ProbabilisticBranchTransitionEntityNameEditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public class BranchTransitionFigure extends RectangleFigure {
		/**
		 * @generated
		 */
		private WrappingLabel fFigureBranchTransitionNameLabel;
		/**
		 * @generated
		 */
		private WrappingLabel fFigureBranchTransitionConditionLabel;
		/**
		 * @generated
		 */
		private WrappingLabel fFigureBranchTransitionProbabilityLabel;

		/**
		 * @generated
		 */
		public BranchTransitionFigure() {

			GridLayout layoutThis = new GridLayout();
			layoutThis.numColumns = 1;
			layoutThis.makeColumnsEqualWidth = true;
			layoutThis.horizontalSpacing = 0;
			layoutThis.verticalSpacing = 0;
			layoutThis.marginWidth = 0;
			layoutThis.marginHeight = 0;
			this.setLayoutManager(layoutThis);

			this.setLineWidth(2);
			this.setLineStyle(Graphics.LINE_DASH);
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			fFigureBranchTransitionNameLabel = new WrappingLabel();
			fFigureBranchTransitionNameLabel.setText("");
			fFigureBranchTransitionNameLabel.setBorder(new MarginBorder(
					getMapMode().DPtoLP(2), getMapMode().DPtoLP(0),
					getMapMode().DPtoLP(2), getMapMode().DPtoLP(0)));

			GridData constraintFFigureBranchTransitionNameLabel = new GridData();
			constraintFFigureBranchTransitionNameLabel.verticalAlignment = GridData.CENTER;
			constraintFFigureBranchTransitionNameLabel.horizontalAlignment = GridData.CENTER;
			constraintFFigureBranchTransitionNameLabel.horizontalIndent = 0;
			constraintFFigureBranchTransitionNameLabel.horizontalSpan = 1;
			constraintFFigureBranchTransitionNameLabel.verticalSpan = 1;
			constraintFFigureBranchTransitionNameLabel.grabExcessHorizontalSpace = false;
			constraintFFigureBranchTransitionNameLabel.grabExcessVerticalSpace = false;
			this.add(fFigureBranchTransitionNameLabel,
					constraintFFigureBranchTransitionNameLabel);

			fFigureBranchTransitionProbabilityLabel = new WrappingLabel();
			fFigureBranchTransitionProbabilityLabel.setText("");
			fFigureBranchTransitionProbabilityLabel.setBorder(new MarginBorder(
					getMapMode().DPtoLP(2), getMapMode().DPtoLP(0),
					getMapMode().DPtoLP(2), getMapMode().DPtoLP(0)));

			GridData constraintFFigureBranchTransitionProbabilityLabel = new GridData();
			constraintFFigureBranchTransitionProbabilityLabel.verticalAlignment = GridData.CENTER;
			constraintFFigureBranchTransitionProbabilityLabel.horizontalAlignment = GridData.CENTER;
			constraintFFigureBranchTransitionProbabilityLabel.horizontalIndent = 0;
			constraintFFigureBranchTransitionProbabilityLabel.horizontalSpan = 1;
			constraintFFigureBranchTransitionProbabilityLabel.verticalSpan = 1;
			constraintFFigureBranchTransitionProbabilityLabel.grabExcessHorizontalSpace = false;
			constraintFFigureBranchTransitionProbabilityLabel.grabExcessVerticalSpace = false;
			this.add(fFigureBranchTransitionProbabilityLabel,
					constraintFFigureBranchTransitionProbabilityLabel);

			fFigureBranchTransitionConditionLabel = new WrappingLabel();
			fFigureBranchTransitionConditionLabel.setText("");
			fFigureBranchTransitionConditionLabel.setBorder(new MarginBorder(
					getMapMode().DPtoLP(2), getMapMode().DPtoLP(0),
					getMapMode().DPtoLP(2), getMapMode().DPtoLP(0)));

			GridData constraintFFigureBranchTransitionConditionLabel = new GridData();
			constraintFFigureBranchTransitionConditionLabel.verticalAlignment = GridData.CENTER;
			constraintFFigureBranchTransitionConditionLabel.horizontalAlignment = GridData.CENTER;
			constraintFFigureBranchTransitionConditionLabel.horizontalIndent = 0;
			constraintFFigureBranchTransitionConditionLabel.horizontalSpan = 1;
			constraintFFigureBranchTransitionConditionLabel.verticalSpan = 1;
			constraintFFigureBranchTransitionConditionLabel.grabExcessHorizontalSpace = false;
			constraintFFigureBranchTransitionConditionLabel.grabExcessVerticalSpace = false;
			this.add(fFigureBranchTransitionConditionLabel,
					constraintFFigureBranchTransitionConditionLabel);

		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureBranchTransitionProbabilityLabel() {
			return fFigureBranchTransitionProbabilityLabel;
		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureBranchTransitionNameLabel() {
			return fFigureBranchTransitionNameLabel;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureBranchTransitionConditionLabel() {
			return fFigureBranchTransitionConditionLabel;
		}

		@Override
		public void add(IFigure figure, Object constraint, int index) {
			Object newConstraint = constraint;
			if (newConstraint == null) {
				GridData layout = new GridData();
				layout.grabExcessHorizontalSpace = true;
				layout.grabExcessVerticalSpace = true;
				layout.horizontalAlignment = SWT.FILL;
				layout.verticalAlignment = SWT.FILL;
				layout.horizontalSpan = 1;
				layout.verticalSpan = 1;

				newConstraint = layout;
			}
			super.add(figure, newConstraint, index);
		}
	}

}
