/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.dialogs.stoex;

import de.uka.ipd.sdq.pcm.dialogs.stoex.StoExTemplateCompletionProcessor;
import de.uka.ipd.sdq.pcm.repository.CollectionDataType;
import de.uka.ipd.sdq.pcm.repository.CompositeDataType;
import de.uka.ipd.sdq.pcm.repository.DataType;
import de.uka.ipd.sdq.pcm.repository.InnerDeclaration;
import de.uka.ipd.sdq.pcm.repository.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class StoExCompletionProcessor
implements IContentAssistProcessor {
    private HashMap<String, String> defaultCharacterisations = new HashMap();
    private HashMap<String, String> parameterNames = new HashMap();
    private String templatePrefixes = "+-*/%(?:";
    private StoExTemplateCompletionProcessor templateProcessor = new StoExTemplateCompletionProcessor();

    public StoExCompletionProcessor(Parameter[] context) {
        this.defaultCharacterisations.put("BYTESIZE", "Characterise the memory footprint in bytes");
        this.defaultCharacterisations.put("NUMBER_OF_ELEMENTS", "Characterise the number of elements of a collection datatype");
        this.defaultCharacterisations.put("STRUCTURE", "Characterise the structure of a datastructure");
        this.defaultCharacterisations.put("VALUE", "Characterise the actual value of a variable");
        this.defaultCharacterisations.put("TYPE", "Characterise the type of a variable");
        int i = 0;
        while (i < context.length) {
            String[] parameterPrefixes;
            String[] stringArray = parameterPrefixes = this.getPrefixesFor(context[i]);
            int n = parameterPrefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterPrefix = stringArray[n2];
                if (parameterPrefix.startsWith("RETURN")) {
                    this.parameterNames.put(parameterPrefix, "Call Result " + context[i].getParameterName());
                } else {
                    this.parameterNames.put(parameterPrefix, "Signature Parameter " + context[i].getParameterName());
                }
                ++n2;
            }
            ++i;
        }
    }

    private String[] getPrefixesFor(Parameter parameter) {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add(parameter.getParameterName());
        this.appendDatatypePrefixes(prefixes, parameter.getParameterName(), parameter.getDatatype__Parameter());
        return prefixes.toArray(new String[0]);
    }

    private void appendDatatypePrefixes(ArrayList<String> prefixes, String parameterName, DataType datatype__Parameter) {
        if (datatype__Parameter instanceof CollectionDataType) {
            prefixes.add(String.valueOf(parameterName) + ".INNER");
            this.appendDatatypePrefixes(prefixes, String.valueOf(parameterName) + ".INNER", ((CollectionDataType)datatype__Parameter).getInnerType_CollectionDataType());
        } else if (datatype__Parameter instanceof CompositeDataType) {
            CompositeDataType cdt = (CompositeDataType)datatype__Parameter;
            for (InnerDeclaration inner : cdt.getInnerDeclaration_CompositeDataType()) {
                prefixes.add(String.valueOf(parameterName) + "." + inner.getEntityName());
                this.appendDatatypePrefixes(prefixes, String.valueOf(parameterName) + "." + inner.getEntityName(), inner.getDatatype_InnerDeclaration());
            }
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String typedFragment;
        int lastIndex;
        ArrayList<ICompletionProposal> resultList = new ArrayList<ICompletionProposal>();
        String currentText = viewer.getDocument().get();
        int lastDotIndex = currentText.substring(0, offset).lastIndexOf(".");
        if (this.isCharactersationCompletionApplicable(lastDotIndex, currentText)) {
            String typedFragment2 = currentText.substring(lastDotIndex + 1, offset);
            this.addCompletionProposalsString(resultList, lastDotIndex, typedFragment2, this.defaultCharacterisations);
        }
        if (this.isStartOfAtom(lastIndex = this.getLastIndexOfTemplatePrefix(offset, currentText), currentText)) {
            typedFragment = currentText.substring(lastIndex + 1, offset).trim();
            this.addCompletionProposalsString(resultList, lastIndex, typedFragment, this.parameterNames);
        }
        if (this.isStartOfAtom(lastIndex, currentText)) {
            typedFragment = currentText.substring(lastIndex + 1, offset).trim();
            ICompletionProposal[] iCompletionProposalArray = this.templateProcessor.computeCompletionProposals(viewer, offset);
            int n = iCompletionProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal p = iCompletionProposalArray[n2];
                if (p.getDisplayString().toUpperCase().startsWith(typedFragment.toUpperCase())) {
                    resultList.add(p);
                }
                ++n2;
            }
        }
        return resultList.toArray(new ICompletionProposal[0]);
    }

    private boolean isCharactersationCompletionApplicable(int offset, String currentText) {
        return offset - 1 >= 0 && offset - 1 < currentText.length() && Character.isLetter(currentText.charAt(offset - 1));
    }

    private boolean isStartOfAtom(int offset, String currentText) {
        String trimText;
        if (offset + 1 < currentText.length() && offset + 1 >= 0) {
            currentText = currentText.substring(offset + 1);
        }
        if ((trimText = currentText.trim()).equals("")) {
            return true;
        }
        char lastChar = trimText.charAt(trimText.length() - 1);
        if (this.templatePrefixes.indexOf(lastChar) >= 0) {
            return true;
        }
        boolean hasOnlyChars = true;
        int i = 0;
        while (i < trimText.length()) {
            if (!Character.isLetter(trimText.charAt(i)) && trimText.charAt(i) != '.') {
                hasOnlyChars = false;
            }
            ++i;
        }
        return hasOnlyChars;
    }

    private int getLastIndexOfTemplatePrefix(int offset, String currentText) {
        int lastIndex = -1;
        String templatePrefixesAndWS = String.valueOf(this.templatePrefixes) + " ";
        int i = 0;
        while (i < templatePrefixesAndWS.length()) {
            int newLastIndex = currentText.substring(0, offset).lastIndexOf(templatePrefixesAndWS.charAt(i));
            if (newLastIndex > lastIndex) {
                lastIndex = newLastIndex;
            }
            ++i;
        }
        return lastIndex;
    }

    private void addCompletionProposalsString(ArrayList<ICompletionProposal> resultList, int lastIndex, String typedFragment, HashMap<String, String> completions) {
        for (Map.Entry<String, String> entry : completions.entrySet()) {
            String completion = entry.getKey();
            String description = entry.getValue();
            if (!completion.toUpperCase().startsWith(typedFragment.toUpperCase())) continue;
            ContextInformation info = new ContextInformation(completion, description);
            resultList.add((ICompletionProposal)new CompletionProposal(completion, lastIndex + 1, typedFragment.length(), completion.length(), null, String.valueOf(completion) + " - " + description, (IContextInformation)info, description));
        }
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        ArrayList<Character> result = new ArrayList<Character>();
        for (String parameterName : this.parameterNames.keySet()) {
            result.add(Character.valueOf(parameterName.charAt(0)));
        }
        int i = 0;
        while (i < this.templatePrefixes.length()) {
            result.add(Character.valueOf(this.templatePrefixes.charAt(i)));
            ++i;
        }
        result.add(Character.valueOf('.'));
        char[] realResult = new char[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            realResult[i2] = ((Character)result.get(i2)).charValue();
            ++i2;
        }
        return realResult;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "No proposals available";
    }
}

