/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.dialogs.datatype;

import de.uka.ipd.sdq.pcm.dialogs.Messages;
import de.uka.ipd.sdq.pcm.dialogs.datatype.DataTypeEnum;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class DataTypeDialog
extends TitleAreaDialog {
    private String entityName;
    private DataTypeEnum editeDataType;
    private Composite composite;
    private Group compositeGroup;
    private Group collectionGroup;
    private Button compositeButton;
    private Button collectionButton;
    private Label nameLabelField;
    private Label typeLabelField;
    private Text nameField;
    private Text typeField;
    private Button typeButton;
    private StackLayout stackLayout;
    private Combo combo;
    private Shell shell;

    public DataTypeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void init(DataTypeEnum dataTyp, String repositoryName, String entityName, String entityInnerType) {
        this.entityName = entityName;
        this.editeDataType = dataTyp;
        this.setTitle(Messages.DataTypeDialog_EditTitle);
        this.shell.setText(Messages.DataTypeDialog_ShellEditTitle);
        if (dataTyp == DataTypeEnum.COLLECTION) {
            this.setTopCollectionLayout();
        }
        if (dataTyp == DataTypeEnum.COMPOSITE) {
            this.setTopCompositeLayout();
        }
        this.combo.setText(repositoryName);
        this.combo.setEnabled(false);
        this.nameField.setText(entityName);
        if (entityInnerType != null) {
            this.typeField.setText(entityInnerType);
        }
        this.setEnabled(true);
        this.setOKButtonDisabled();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
        newShell.setText(Messages.DataTypeDialog_ShellNewTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        Group reposetoryGroup = new Group(container, 0);
        reposetoryGroup.setText("Repository");
        reposetoryGroup.setLayoutData((Object)new GridData(478, 30));
        reposetoryGroup.setLayout((Layout)new GridLayout());
        this.combo = new Combo((Composite)reposetoryGroup, 12);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDialog.this.setEditedResource(DataTypeDialog.this.combo.getText());
                DataTypeDialog.this.setEnabled(true);
                DataTypeDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DataTypeDialog.this.setEditedResource(DataTypeDialog.this.combo.getText());
                DataTypeDialog.this.setEnabled(true);
                DataTypeDialog.this.validateInput();
            }
        });
        this.combo.setItems(this.getLoadedRepositories());
        Group choiceTypeGroup = new Group(container, 16);
        choiceTypeGroup.setText("Choose DataType");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        choiceTypeGroup.setLayout((Layout)gridLayout);
        choiceTypeGroup.setLayoutData((Object)new GridData(478, 74));
        this.composite = new Composite(container, 0);
        this.stackLayout = new StackLayout();
        this.composite.setLayout((Layout)this.stackLayout);
        this.composite.setLayoutData((Object)new GridData(484, 139));
        this.collectionButton = new Button((Composite)choiceTypeGroup, 16);
        this.collectionButton.setLayoutData((Object)new GridData(129, -1));
        this.collectionButton.setText("CollectionDataType");
        this.collectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDialog.this.setTopCollectionLayout();
                DataTypeDialog.this.validateInput();
            }
        });
        new Label((Composite)choiceTypeGroup, 0);
        this.compositeButton = new Button((Composite)choiceTypeGroup, 16);
        this.compositeButton.setText("CompositeDataType");
        this.compositeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDialog.this.setTopCompositeLayout();
                DataTypeDialog.this.validateInput();
            }
        });
        new Label((Composite)choiceTypeGroup, 0);
        this.nameLabelField = new Label((Composite)choiceTypeGroup, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false);
        gridData.widthHint = 107;
        this.nameLabelField.setLayoutData((Object)gridData);
        this.nameLabelField.setText("Name:");
        this.nameField = new Text((Composite)choiceTypeGroup, 2048);
        GridData gdNameField = new GridData(16384, 0x1000000, true, false);
        gdNameField.widthHint = 334;
        this.nameField.setLayoutData((Object)gdNameField);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataTypeDialog.this.validateInput();
            }
        });
        this.compositeGroup = new Group(this.composite, 0);
        this.compositeGroup.setLayout((Layout)new FormLayout());
        this.compositeGroup.setText("innerDeclaration CompositeDataType");
        this.createInnerSectionCompositeGroup((Composite)this.compositeGroup);
        this.collectionGroup = new Group(this.composite, 0);
        GridLayout gridLayoutCollGroup = new GridLayout();
        gridLayoutCollGroup.numColumns = 3;
        this.collectionGroup.setLayout((Layout)gridLayoutCollGroup);
        this.collectionGroup.setText("innerType CollectionDataType");
        this.typeLabelField = new Label((Composite)this.collectionGroup, 0);
        this.typeLabelField.setLayoutData((Object)new GridData(40, -1));
        this.typeLabelField.setText("Type: ");
        this.typeField = new Text((Composite)this.collectionGroup, 2060);
        this.typeField.setLayoutData((Object)new GridData(200, 15));
        this.typeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataTypeDialog.this.validateInput();
            }
        });
        this.typeButton = new Button((Composite)this.collectionGroup, 0);
        this.typeButton.setLayoutData((Object)new GridData(-1, 20));
        this.typeButton.setText("Select...");
        this.typeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDialog.this.typeField.setText(DataTypeDialog.this.getSelectedInnerType(e));
            }
        });
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(482, -1));
        this.setTitle(Messages.DataTypeDialog_NewTitle);
        this.setTopCollectionLayout();
        this.setEnabled(false);
        return container;
    }

    public void setEnabled(boolean enabled) {
        this.compositeButton.setEnabled(enabled);
        this.collectionButton.setEnabled(enabled);
        this.typeLabelField.setEnabled(enabled);
        this.typeField.setEnabled(enabled);
        this.typeButton.setEnabled(enabled);
        this.nameLabelField.setEnabled(enabled);
        this.nameField.setEnabled(enabled);
    }

    protected Point getInitialSize() {
        return new Point(500, 446);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.getButton(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataTypeDialog.this.editeDataType == DataTypeEnum.COLLECTION) {
                    DataTypeDialog.this.createCollectionDataType();
                }
                if (DataTypeDialog.this.editeDataType == DataTypeEnum.COMPOSITE) {
                    DataTypeDialog.this.createCompositeDataType();
                }
            }
        });
        this.setOKButtonDisabled();
    }

    protected void setOKButtonEnabled() {
        this.getButton(0).setEnabled(true);
    }

    protected void setOKButtonDisabled() {
        this.getButton(0).setEnabled(false);
    }

    public abstract String[] getLoadedRepositories();

    public abstract void createInnerSectionCompositeGroup(Composite var1);

    public abstract String getSelectedInnerType(SelectionEvent var1);

    public abstract void setEditedResource(String var1);

    public abstract void createCollectionDataType();

    public abstract void createCompositeDataType();

    public abstract boolean validateCompositeDataType();

    protected String getEntityName() {
        return this.entityName;
    }

    protected void setTopCompositeLayout() {
        this.collectionButton.setSelection(false);
        this.compositeButton.setSelection(true);
        this.stackLayout.topControl = this.compositeGroup;
        this.composite.layout();
        this.editeDataType = DataTypeEnum.COMPOSITE;
    }

    protected void setTopCollectionLayout() {
        this.compositeButton.setSelection(false);
        this.collectionButton.setSelection(true);
        this.stackLayout.topControl = this.collectionGroup;
        this.composite.layout();
        this.editeDataType = DataTypeEnum.COLLECTION;
    }

    public void validateInput() {
        this.entityName = this.nameField.getText();
        if (this.entityName.equals("")) {
            this.setOKButtonDisabled();
            this.setErrorMessage(Messages.DataTypeDialog_ErrorMsgName);
            return;
        }
        if (this.collectionButton.getSelection() && this.typeField.getText().equals("")) {
            this.setOKButtonDisabled();
            this.setErrorMessage(Messages.DataTypeDialog_ErrorMsgInner);
        } else if (this.compositeButton.getSelection() && !this.validateCompositeDataType()) {
            this.setOKButtonDisabled();
        } else {
            this.setErrorMessage(null);
            this.setOKButtonEnabled();
        }
    }
}

