/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.launchmultiple;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LaunchMultipleTab
extends AbstractLaunchConfigurationTab {
    private List<Button> buttons = new ArrayList<Button>();
    private String[] launchTypes = new String[]{"de.uka.ipd.sdq.simucontroller.SimuLaunching", "de.uka.ipd.sdq.dsolver_plugin.PCMSolverLaunchConfigurationType", "de.uka.ipd.sdq.dsolver_plugin.PCMSolverLaunchConfigurationType.Reliability", "de.uka.ipd.sdq.dsexplore.launchDSE"};
    private static LaunchMultipleTab instance;
    private static Logger logger;

    static {
        logger = Logger.getLogger((String)"de.uka.ipd.sdq.launchmultiple");
    }

    public void createControl(Composite parent) {
        instance = this;
        Composite container = new Composite(parent, 0);
        GridLayout layoutOuter = new GridLayout();
        layoutOuter.numColumns = 3;
        container.setLayout((Layout)layoutOuter);
        this.setControl((Control)container);
        this.buttons = new ArrayList<Button>();
        Group loggingGroup = new Group(container, 0);
        loggingGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        loggingGroup.setText("Choose Launch Configs to run.");
        GridLayout layoutInner = new GridLayout();
        layoutInner.numColumns = 3;
        loggingGroup.setLayout((Layout)layoutInner);
        List<ILaunchConfiguration> configs = this.getLaunchConfigs();
        for (ILaunchConfiguration launchConfiguration : configs) {
            this.buttons.add(this.createCheckBox(launchConfiguration, loggingGroup));
        }
    }

    public List<ILaunchConfiguration> getLaunchConfigs() {
        ILaunchManager manager = this.getLaunchManager();
        LinkedList<ILaunchConfiguration> allTypes = new LinkedList<ILaunchConfiguration>();
        String[] stringArray = this.launchTypes;
        int n = this.launchTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String launchTypeID = stringArray[n2];
            try {
                ILaunchConfigurationType launchType = manager.getLaunchConfigurationType(launchTypeID);
                ILaunchConfiguration[] configs = null;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(launchType);
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n4];
                    allTypes.add(iLaunchConfiguration);
                    ++n4;
                }
            }
            catch (CoreException e) {
                logger.error((Object)("Could not find a configuration type for id " + launchTypeID + ", skipping it."));
                e.printStackTrace();
            }
            ++n2;
        }
        return allTypes;
    }

    private Button createCheckBox(ILaunchConfiguration launchConfiguration, Group launchConfigGroup) {
        Button launchConfigButton = new Button((Composite)launchConfigGroup, 32);
        launchConfigButton.setText(launchConfiguration.getName());
        launchConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchMultipleTab.this.updateLaunchConfigurationDialog();
            }
        });
        launchConfigButton.setSelection(false);
        return launchConfigButton;
    }

    public String getName() {
        return "Launch Multiple Runs Tab";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        List<ILaunchConfiguration> configs = this.getLaunchConfigs();
        for (ILaunchConfiguration launchConfiguration : configs) {
            boolean selected = false;
            try {
                selected = configuration.getAttribute(launchConfiguration.getName(), false);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            Button button = this.getButtonFor(launchConfiguration.getName());
            if (button == null) continue;
            button.setSelection(selected);
        }
    }

    private Button getButtonFor(String name) {
        for (Button button : this.buttons) {
            if (!button.getText().equals(name)) continue;
            return button;
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        for (Button button : this.buttons) {
            config.setAttribute(button.getText(), button.getSelection());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        for (Button button : this.buttons) {
            config.setAttribute(button.getText(), true);
        }
    }

    public static LaunchMultipleTab getAnyInstance() {
        return instance;
    }
}

