/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.launchmultiple;

import de.uka.ipd.sdq.launchmultiple.LaunchMultipleTab;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public class LaunchMultiple
implements ILaunchConfigurationDelegate {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.launchmultiple");

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        LaunchMultipleTab tab = LaunchMultipleTab.getAnyInstance();
        List<ILaunchConfiguration> configs = tab.getLaunchConfigs();
        ArrayList<ILaunchConfiguration> configsToBeLaunched = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration launchConfiguration : configs) {
            boolean toBeLaunched = configuration.getAttribute(launchConfiguration.getName(), false);
            if (!toBeLaunched) continue;
            configsToBeLaunched.add(launchConfiguration);
        }
        for (ILaunchConfiguration launchConfiguration : configsToBeLaunched) {
            try {
                HashSet<String> modes = new HashSet<String>();
                modes.add(mode);
                ILaunchConfigurationDelegate delegate = launchConfiguration.getType().getDelegates(modes)[0].getDelegate();
                delegate.launch(launchConfiguration, mode, launch, monitor);
            }
            catch (Exception e) {
                logger.error((Object)("Running " + launchConfiguration.getName() + " failed. I will start the next one. Cause: " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }
}

