package de.uka.ipd.sdq.errorhandling;

import org.eclipse.emf.ecore.EObject;

public class SeverityAndIssue implements Comparable<SeverityAndIssue> {

	private final SeverityEnum error;
	private String message;
	private EObject element;
	
	public SeverityAndIssue(SeverityEnum error, String message, EObject element) {
		this.error = error;
		this.message = message;
		this.element = element;
	}

	public String getMessage(){
		return message;
	}
	
	/**
	 * May be null
	 * @return the EObject or null
	 */
	public EObject getElement() {
		return element;
	}

	/**
	 * Return the resource name or an empty String if this {@link SeverityAndIssue} has no element.
	 * @return
	 */
	public String getResourceName() {
		if (element != null){
			return element.eResource().getURI().toFileString();
		} else 
			return "";
		
	}
	
	public SeverityEnum getError() {
		return error;
	}

	public int compareTo(SeverityAndIssue o) {
		if (this.error == o.getError())
			return 0;
		if (this.error == SeverityEnum.ERROR && o.getError() == SeverityEnum.WARNING)
			return -1;
		else
			return 1;
	}

}
